/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.Arrays;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ControlUtil;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.WidgetRemoteAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ControlRemoteAdapter
extends WidgetRemoteAdapter {
    private static final int PARENT = 11;
    private static final int BOUNDS = 12;
    private static final int CHILDREN = 13;
    private static final int TOOL_TIP_TEXT = 14;
    private static final int MENU = 15;
    private static final int FOREGROUND = 16;
    private static final int BACKGROUND = 17;
    private static final int FONT = 18;
    private static final int CURSOR = 19;
    private static final int VISIBLE = 20;
    private static final int ENABLED = 21;
    private static final int BACKGROUND_IMAGE = 22;
    private static final int ACTIVE_KEYS = 23;
    private static final int CANCEL_KEYS = 24;
    private static final int TAB_INDEX = 25;
    private static final int ORIENTATION = 26;
    private static final String PROP_PARENT = "parent";
    private static final String PROP_BOUNDS = "bounds";
    private static final String PROP_CHILDREN = "children";
    private static final String PROP_TAB_INDEX = "tabIndex";
    private static final String PROP_TOOLTIP_TEXT = "toolTip";
    private static final String PROP_MENU = "menu";
    private static final String PROP_VISIBLE = "visibility";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_ORIENTATION = "direction";
    private static final String PROP_FOREGROUND = "foreground";
    private static final String PROP_BACKGROUND = "background";
    private static final String PROP_BACKGROUND_IMAGE = "backgroundImage";
    private static final String PROP_FONT = "font";
    private static final String PROP_CURSOR = "cursor";
    private transient Composite parent;
    private transient Control[] children;
    private transient Rectangle bounds;
    private transient int tabIndex;
    private transient String toolTipText;
    private transient Menu menu;
    private transient boolean visible;
    private transient boolean enabled;
    private transient boolean rtl;
    private transient Color foreground;
    private transient Color background;
    private transient boolean backgroundTransparency;
    private transient Image backgroundImage;
    private transient Font font;
    private transient Cursor cursor;
    private transient String[] activeKeys;
    private transient String[] cancelKeys;

    public ControlRemoteAdapter(String id) {
        super(id);
    }

    public void preserveParent(Composite parent) {
        if (!this.hasPreserved(11)) {
            this.markPreserved(11);
            this.parent = parent;
        }
    }

    public void renderParent(Control control) {
        Composite actual;
        if (this.isInitialized() && this.hasPreserved(11) && this.changed(actual = control.getParent(), this.parent, null)) {
            this.getRemoteObject().set(PROP_PARENT, JsonMapping.toJson(actual));
        }
    }

    public void preserveChildren(Control[] children) {
        if (!this.hasPreserved(13)) {
            this.markPreserved(13);
            this.children = children;
        }
    }

    public void renderChildren(Composite composite) {
        Object[] actual;
        if ((!this.isInitialized() || this.hasPreserved(13)) && this.changed(actual = composite.getChildren(), this.children, null)) {
            this.getRemoteObject().set(PROP_CHILDREN, JsonMapping.toJson((Widget[])actual));
        }
    }

    public void preserveBounds(Rectangle bounds) {
        if (!this.hasPreserved(12)) {
            this.markPreserved(12);
            this.bounds = bounds;
        }
    }

    public void renderBounds(IControlAdapter controlAdapter) {
        Rectangle actual;
        if ((!this.isInitialized() || this.hasPreserved(12)) && this.changed(actual = controlAdapter.getBounds(), this.bounds, null)) {
            this.getRemoteObject().set(PROP_BOUNDS, JsonMapping.toJson(actual));
        }
    }

    public void preserveTabIndex(int tabIndex) {
        if (!this.hasPreserved(25)) {
            this.markPreserved(25);
            this.tabIndex = tabIndex;
        }
    }

    public void renderTabIndex(Control control) {
        if (this.hasPreserved(25)) {
            int actual = ControlUtil.getControlAdapter(control).getTabIndex();
            if (!this.isInitialized() || actual != this.tabIndex) {
                this.getRemoteObject().set(PROP_TAB_INDEX, actual);
            }
        }
    }

    public void preserveToolTipText(String toolTipText) {
        if (!this.hasPreserved(14)) {
            this.markPreserved(14);
            this.toolTipText = toolTipText;
        }
    }

    public void renderToolTipText(Control control) {
        String actual;
        if (this.hasPreserved(14) && this.changed(actual = control.getToolTipText(), this.toolTipText, null)) {
            String text;
            String string = text = actual == null ? "" : actual;
            if (!MarkupUtil.isToolTipMarkupEnabledFor(control)) {
                text = MnemonicUtil.removeAmpersandControlCharacters(text);
            }
            this.getRemoteObject().set(PROP_TOOLTIP_TEXT, text);
        }
    }

    public void preserveMenu(Menu menu) {
        if (!this.hasPreserved(15)) {
            this.markPreserved(15);
            this.menu = menu;
        }
    }

    public void renderMenu(Control control) {
        Menu actual;
        if (this.hasPreserved(15) && this.changed(actual = control.getMenu(), this.menu, null)) {
            this.getRemoteObject().set(PROP_MENU, JsonMapping.toJson(actual));
        }
    }

    public void preserveVisible(boolean visible) {
        if (!this.hasPreserved(20)) {
            this.markPreserved(20);
            this.visible = visible;
        }
    }

    public void renderVisible(Control control) {
        boolean actual;
        if (this.hasPreserved(20) && this.changed(actual = control.getVisible(), this.visible, !(control instanceof Shell))) {
            this.getRemoteObject().set(PROP_VISIBLE, actual);
        }
    }

    public void preserveEnabled(boolean enabled) {
        if (!this.hasPreserved(21)) {
            this.markPreserved(21);
            this.enabled = enabled;
        }
    }

    public void renderEnabled(Control control) {
        boolean actual;
        if (this.hasPreserved(21) && this.changed(actual = control.getEnabled(), this.enabled, true)) {
            this.getRemoteObject().set(PROP_ENABLED, actual);
        }
    }

    public void preserveOrientation(int orientation) {
        if (!this.hasPreserved(26)) {
            this.markPreserved(26);
            this.rtl = orientation == 0x4000000;
        }
    }

    public void renderOrientation(Control control) {
        if (!this.isInitialized() || this.hasPreserved(26)) {
            boolean actual;
            boolean bl = actual = (control.getStyle() & 0x4000000) == 0x4000000;
            if (this.changed(actual, this.rtl, false)) {
                this.getRemoteObject().set(PROP_ORIENTATION, actual ? "rtl" : "ltr");
            }
        }
    }

    public void preserveForeground(Color foreground) {
        if (!this.hasPreserved(16)) {
            this.markPreserved(16);
            this.foreground = foreground;
        }
    }

    public void renderForeground(IControlAdapter controlAdapter) {
        Color actual;
        if (this.hasPreserved(16) && this.changed(actual = controlAdapter.getUserForeground(), this.foreground, null)) {
            this.getRemoteObject().set(PROP_FOREGROUND, JsonMapping.toJson(actual));
        }
    }

    public void preserveBackground(Color background, boolean transparency) {
        if (!this.hasPreserved(17)) {
            this.markPreserved(17);
            this.background = background;
            this.backgroundTransparency = transparency;
        }
    }

    public void renderBackground(IControlAdapter controlAdapter) {
        if (this.hasPreserved(17)) {
            Color actualBackground = controlAdapter.getUserBackground();
            boolean actualTransparency = controlAdapter.getBackgroundTransparency();
            boolean colorChanged = this.changed(actualBackground, this.background, null);
            boolean transparencyChanged = this.changed(actualTransparency, this.backgroundTransparency, false);
            if (transparencyChanged || colorChanged) {
                RGB rgb = null;
                int alpha = 0;
                if (actualBackground != null) {
                    rgb = actualBackground.getRGB();
                    alpha = actualTransparency ? 0 : actualBackground.getAlpha();
                } else if (actualTransparency) {
                    rgb = new RGB(0, 0, 0);
                }
                this.getRemoteObject().set(PROP_BACKGROUND, JsonMapping.toJson(rgb, alpha));
            }
        }
    }

    public void preserveBackgroundImage(Image backgroundImage) {
        if (!this.hasPreserved(22)) {
            this.markPreserved(22);
            this.backgroundImage = backgroundImage;
        }
    }

    public void renderBackgroundImage(IControlAdapter controlAdapter) {
        Image actual;
        if (this.hasPreserved(22) && this.changed(actual = controlAdapter.getUserBackgroundImage(), this.backgroundImage, null)) {
            this.getRemoteObject().set(PROP_BACKGROUND_IMAGE, JsonMapping.toJson(actual));
        }
    }

    public void preserveFont(Font font) {
        if (!this.hasPreserved(18)) {
            this.markPreserved(18);
            this.font = font;
        }
    }

    public void renderFont(IControlAdapter controlAdapter) {
        Font actual;
        if (this.hasPreserved(18) && this.changed(actual = controlAdapter.getUserFont(), this.font, null)) {
            this.getRemoteObject().set(PROP_FONT, JsonMapping.toJson(actual));
        }
    }

    public void preserveCursor(Cursor cursor) {
        if (!this.hasPreserved(19)) {
            this.markPreserved(19);
            this.cursor = cursor;
        }
    }

    public void renderCursor(Control control) {
        Cursor actual;
        if (this.hasPreserved(19) && this.changed(actual = control.getCursor(), this.cursor, null)) {
            this.getRemoteObject().set(PROP_CURSOR, JsonMapping.toJson(actual));
        }
    }

    public void preserveActiveKeys(String[] activeKeys) {
        this.markPreserved(23);
        this.activeKeys = activeKeys;
    }

    public boolean hasPreservedActiveKeys() {
        return this.hasPreserved(23);
    }

    public String[] getPreservedActiveKeys() {
        return this.activeKeys;
    }

    public void preserveCancelKeys(String[] cancelKeys) {
        this.markPreserved(24);
        this.cancelKeys = cancelKeys;
    }

    public boolean hasPreservedCancelKeys() {
        return this.hasPreserved(24);
    }

    public String[] getPreservedCancelKeys() {
        return this.cancelKeys;
    }

    @Override
    public void clearPreserved() {
        super.clearPreserved();
        this.parent = null;
        this.children = null;
        this.bounds = null;
        this.tabIndex = 0;
        this.toolTipText = null;
        this.menu = null;
        this.visible = false;
        this.enabled = false;
        this.rtl = false;
        this.foreground = null;
        this.background = null;
        this.backgroundTransparency = false;
        this.backgroundImage = null;
        this.font = null;
        this.cursor = null;
        this.activeKeys = null;
        this.cancelKeys = null;
    }

    private Object readResolve() {
        this.initialize();
        return this;
    }

    private boolean changed(boolean actualValue, boolean preservedValue, boolean defaultValue) {
        return actualValue ^ (this.isInitialized() ? preservedValue : defaultValue);
    }

    private boolean changed(Object actualValue, Object preservedValue, Object defaultValue) {
        return !ControlRemoteAdapter.equals(actualValue, this.isInitialized() ? preservedValue : defaultValue);
    }

    private boolean changed(Object[] actualValue, Object[] preservedValue, Object[] defaultValue) {
        return !Arrays.equals(actualValue, this.isInitialized() ? preservedValue : defaultValue);
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }
}

