/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class ProgressBarTab
extends ExampleTab {
    private static final int COUNT = 20;
    private ProgressBar progressBar;
    private ServerPushSession serverPush = new ServerPushSession();

    public ProgressBarTab() {
        super("ProgressBar");
    }

    @Override
    protected void createExampleControls(Composite parent) {
        int style = this.getStyle() == 0 ? 256 : this.getStyle();
        parent.setLayout((Layout)new GridLayout());
        this.progressBar = new ProgressBar(parent, style);
        this.registerControl((Control)this.progressBar);
        this.progressBar.setMaximum(20);
        final Button button = new Button(parent, 8);
        button.setText("Start Background Process");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                button.setEnabled(false);
                ProgressBarTab.this.serverPush.start();
                Thread thread = new Thread(ProgressBarTab.this.createRunnable(ProgressBarTab.this.progressBar, button));
                thread.setDaemon(true);
                thread.start();
            }
        });
        button.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent evt) {
                Point size = button.getSize();
                if ((ProgressBarTab.this.progressBar.getStyle() & 0x100) != 0) {
                    ProgressBarTab.this.progressBar.setLayoutData((Object)new GridData(Math.max(200, size.x), -1));
                } else {
                    ProgressBarTab.this.progressBar.setLayoutData((Object)new GridData(-1, 150));
                }
            }
        });
        parent.layout();
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("HORIZONTAL", 256, true);
        this.createStyleButton("VERTICAL", 512, false);
        this.createStyleButton("INDETERMINATE", 2, false);
        this.createOrientationButton();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createBgImageButton();
        this.createBgColorButton();
        this.createStateControl();
    }

    private void createStateControl() {
        final Combo combo = new Combo(this.styleComp, 2056);
        combo.setItems(new String[]{"SWT.NORMAL", "SWT.PAUSED", "SWT.ERROR"});
        combo.select(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = combo.getSelectionIndex();
                if (index == 2) {
                    ProgressBarTab.this.progressBar.setState(1);
                } else if (index == 1) {
                    ProgressBarTab.this.progressBar.setState(4);
                } else {
                    ProgressBarTab.this.progressBar.setState(0);
                }
            }
        });
    }

    private Runnable createRunnable(final ProgressBar progressBar, final Button button) {
        final int maximum = progressBar.getMaximum();
        final Display display = progressBar.getDisplay();
        Runnable result = new Runnable(){

            @Override
            public void run() {
                final Composite[] panel = new Composite[1];
                int i = 0;
                while (i <= maximum) {
                    final int selection = i;
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Throwable shouldNotHappen) {
                        shouldNotHappen.printStackTrace();
                    }
                    if (!display.isDisposed()) {
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!progressBar.isDisposed()) {
                                    progressBar.setSelection(selection);
                                    if (selection == maximum) {
                                        button.setEnabled(true);
                                        ProgressBarTab.this.serverPush.stop();
                                        if (panel[0] != null) {
                                            panel[0].dispose();
                                        }
                                    }
                                }
                            }
                        });
                    }
                    ++i;
                }
            }
        };
        return result;
    }
}

