/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.cheatsheets;

import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetView;
import org.eclipse.ui.internal.cheatsheets.views.ViewUtilities;

public final class OpenCheatSheetAction
extends Action {
    private String id;
    private String name;
    private URL url;
    private String xml;
    private String basePath;

    public OpenCheatSheetAction(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    public OpenCheatSheetAction(String id, String name, URL url) {
        if (id == null || name == null || url == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.name = name;
        this.url = url;
    }

    public OpenCheatSheetAction(String id, String name, String xml, URL baseURL) {
        if (id == null || name == null || xml == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.name = name;
        this.xml = xml;
        if (baseURL != null) {
            this.basePath = baseURL.toExternalForm();
        }
    }

    public void run() {
        CheatSheetView view = ViewUtilities.showCheatSheetView();
        if (view == null) {
            return;
        }
        if (this.url != null) {
            view.setInput(this.id, this.name, this.url);
        } else if (this.xml != null) {
            view.setInputFromXml(this.id, this.name, this.xml, this.basePath);
        } else {
            view.setInput(this.id);
        }
        IWorkbenchPage page = view.getSite().getWorkbenchWindow().getActivePage();
        page.bringToTop((IWorkbenchPart)view);
    }
}

