/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class History {
    private static final int SIZE_DEFAULT = 100;
    private LinkedList<String> commands = new LinkedList();
    private int limit = 100;

    CharSequence evaluate(CharSequence commandLine) {
        String event;
        StringCharacterIterator ci = new StringCharacterIterator(commandLine.toString());
        char c = ci.current();
        if (c == '!') {
            c = ci.next();
            if (c == '!') {
                event = this.commands.getLast();
                ci.next();
            } else if (c >= '0' && c <= '9' || c == '-') {
                event = this.getCommand(ci);
            } else if (c == '?') {
                event = this.findContains(ci);
                ci.next();
            } else {
                ci.previous();
                event = this.findStartsWith(ci);
            }
        } else if (c == '^') {
            event = this.subst(ci, c, false, this.commands.getLast());
        } else {
            throw new IllegalArgumentException(commandLine + ": Unsupported event");
        }
        if (ci.current() == ':') {
            boolean global;
            c = ci.next();
            boolean bl = global = c == 'a' || c == 'g';
            if (global) {
                c = ci.next();
            }
            if (c == 's') {
                event = this.subst(ci, ci.next(), global, event);
            }
        }
        return event;
    }

    Iterator<String> getHistory() {
        return this.commands.iterator();
    }

    void append(CharSequence commandLine) {
        this.commands.add(commandLine.toString());
        if (this.commands.size() > this.limit) {
            this.commands.removeFirst();
        }
    }

    private String getCommand(CharacterIterator ci) {
        StringBuilder s = new StringBuilder();
        char c = ci.current();
        do {
            s.append(c);
        } while ((c = ci.next()) >= '0' && c <= '9');
        int n = Integer.parseInt(s.toString());
        int pos = (n < 0 ? this.commands.size() : -1) + n;
        if (pos >= 0 && pos < this.commands.size()) {
            return this.commands.get(pos);
        }
        throw new IllegalArgumentException("!" + n + ": event not found");
    }

    private String findContains(CharacterIterator ci) {
        CharSequence part = this.findDelimiter(ci, '?');
        ListIterator<String> iter = this.commands.listIterator(this.commands.size());
        while (iter.hasPrevious()) {
            String value = iter.previous();
            if (!value.contains(part)) continue;
            return value;
        }
        throw new IllegalArgumentException("No command containing '" + part + "' in the history");
    }

    private String findStartsWith(CharacterIterator ci) {
        String part = this.findDelimiter(ci, ':').toString();
        ListIterator<String> iter2 = this.commands.listIterator(this.commands.size());
        while (iter2.hasPrevious()) {
            String value = iter2.previous();
            if (!value.startsWith(part)) continue;
            return value;
        }
        throw new IllegalArgumentException("No command containing '" + part + "' in the history");
    }

    private String subst(CharacterIterator ci, char delimiter, boolean replaceAll, String event) {
        String pattern = this.findDelimiter(ci, delimiter).toString();
        String repl = this.findDelimiter(ci, delimiter).toString();
        if (pattern.length() == 0) {
            throw new IllegalArgumentException(":s" + event + ": substitution failed");
        }
        Pattern regex = Pattern.compile(pattern);
        Matcher m = regex.matcher(event);
        StringBuffer res = new StringBuffer();
        if (!m.find()) {
            throw new IllegalArgumentException(":s" + event + ": substitution failed");
        }
        do {
            m.appendReplacement(res, repl);
        } while (replaceAll && m.find());
        m.appendTail(res);
        return res.toString();
    }

    private CharSequence findDelimiter(CharacterIterator ci, char delimiter) {
        StringBuilder b = new StringBuilder();
        char c = ci.next();
        while (c != '\uffff' && c != delimiter) {
            if (c == '\\') {
                c = ci.next();
            }
            b.append(c);
            c = ci.next();
        }
        return b;
    }
}

