/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tableitemkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.ITableItemAdapter;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.internal.widgets.WidgetRemoteAdapter;
import org.eclipse.swt.internal.widgets.tableitemkit.TableItemOperationHandler;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class TableItemLCA
extends WidgetLCA<TableItem> {
    public static final TableItemLCA INSTANCE = new TableItemLCA();
    private static final String TYPE = "rwt.widgets.GridItem";
    static final String PROP_INDEX = "index";
    static final String PROP_TEXTS = "texts";
    static final String PROP_IMAGES = "images";
    static final String PROP_CELL_BACKGROUNDS = "cellBackgrounds";
    static final String PROP_CELL_FOREGROUNDS = "cellForegrounds";
    static final String PROP_CELL_FONTS = "cellFonts";
    static final String PROP_CHECKED = "checked";
    static final String PROP_GRAYED = "grayed";
    static final String PROP_CACHED = "cached";

    @Override
    public void preserveValues(TableItem item) {
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_INDEX, TableItemLCA.getIndex(item));
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_CACHED, TableItemLCA.isCached(item));
        if (TableItemLCA.isCached(item)) {
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_TEXTS, TableItemLCA.getTexts(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_IMAGES, TableItemLCA.getImages(item));
            WidgetLCAUtil.preserveBackground(item, TableItemLCA.getUserBackground(item));
            WidgetLCAUtil.preserveForeground(item, TableItemLCA.getUserForeground(item));
            WidgetLCAUtil.preserveFont(item, TableItemLCA.getUserFont(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_BACKGROUNDS, TableItemLCA.getCellBackgrounds(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_FOREGROUNDS, TableItemLCA.getCellForegrounds(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CELL_FONTS, TableItemLCA.getCellFonts(item));
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_CHECKED, item.getChecked());
            WidgetLCAUtil.preserveProperty((Widget)item, PROP_GRAYED, item.getGrayed());
        }
    }

    @Override
    public void renderInitialization(TableItem item) throws IOException {
        Table parent = item.getParent();
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(item, TYPE);
        remoteObject.setHandler(new TableItemOperationHandler(item));
        remoteObject.set("parent", WidgetUtil.getId(parent));
    }

    @Override
    public void renderChanges(final TableItem item) throws IOException {
        WidgetLCAUtil.renderProperty((Widget)item, PROP_INDEX, TableItemLCA.getIndex(item), -1);
        if (TableItemLCA.wasCleared(item)) {
            TableItemLCA.renderClear(item);
        } else if (TableItemLCA.isCached(item)) {
            TableItemLCA.preservingInitialized(item, new IRenderRunnable(){

                @Override
                public void run() throws IOException {
                    if (!TableItemLCA.wasCached(item)) {
                        TableItemLCA.setInitialized(item, false);
                    }
                    TableItemLCA.renderProperties(item);
                }
            });
        }
    }

    private static void renderProperties(TableItem item) {
        WidgetLCAUtil.renderProperty((Widget)item, PROP_TEXTS, TableItemLCA.getTexts(item), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_IMAGES, TableItemLCA.getImages(item), null);
        WidgetLCAUtil.renderBackground(item, TableItemLCA.getUserBackground(item));
        WidgetLCAUtil.renderForeground(item, TableItemLCA.getUserForeground(item));
        WidgetLCAUtil.renderFont(item, TableItemLCA.getUserFont(item));
        WidgetLCAUtil.renderCustomVariant(item);
        WidgetLCAUtil.renderData(item);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_BACKGROUNDS, TableItemLCA.getCellBackgrounds(item), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_FOREGROUNDS, TableItemLCA.getCellForegrounds(item), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_CELL_FONTS, TableItemLCA.getCellFonts(item), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_CHECKED, item.getChecked(), false);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_GRAYED, item.getGrayed(), false);
    }

    private static void renderClear(TableItem item) {
        RemoteObjectFactory.getRemoteObject(item).call("clear", null);
    }

    private static int getIndex(TableItem item) {
        return item.getParent().indexOf(item);
    }

    private static boolean isCached(TableItem item) {
        Table table = item.getParent();
        ITableAdapter adapter = table.getAdapter(ITableAdapter.class);
        return !adapter.isItemVirtual(table.indexOf(item));
    }

    static String[] getTexts(TableItem item) {
        return TableItemLCA.getTableItemAdapter(item).getTexts();
    }

    static Image[] getImages(TableItem item) {
        return TableItemLCA.getTableItemAdapter(item).getImages();
    }

    private static Color getUserBackground(TableItem item) {
        return item.getAdapter(IWidgetColorAdapter.class).getUserBackground();
    }

    private static Color getUserForeground(TableItem item) {
        return item.getAdapter(IWidgetColorAdapter.class).getUserForeground();
    }

    private static Font getUserFont(TableItem item) {
        return item.getAdapter(IWidgetFontAdapter.class).getUserFont();
    }

    private static Color[] getCellBackgrounds(TableItem item) {
        return TableItemLCA.getTableItemAdapter(item).getCellBackgrounds();
    }

    private static Color[] getCellForegrounds(TableItem item) {
        return TableItemLCA.getTableItemAdapter(item).getCellForegrounds();
    }

    private static Font[] getCellFonts(TableItem item) {
        return TableItemLCA.getTableItemAdapter(item).getCellFonts();
    }

    private static boolean wasCleared(TableItem item) {
        boolean cached = TableItemLCA.isCached(item);
        boolean wasCached = TableItemLCA.wasCached(item);
        return !cached && wasCached;
    }

    private static boolean wasCached(TableItem item) {
        boolean wasCached;
        RemoteAdapter adapter = WidgetUtil.getAdapter(item);
        if (adapter.isInitialized()) {
            Boolean preserved = (Boolean)adapter.getPreserved(PROP_CACHED);
            wasCached = Boolean.TRUE.equals(preserved);
        } else {
            wasCached = true;
        }
        return wasCached;
    }

    private static ITableItemAdapter getTableItemAdapter(TableItem item) {
        return item.getAdapter(ITableItemAdapter.class);
    }

    private static void preservingInitialized(TableItem item, IRenderRunnable runnable) throws IOException {
        boolean initialized = WidgetUtil.getAdapter(item).isInitialized();
        runnable.run();
        TableItemLCA.setInitialized(item, initialized);
    }

    private static void setInitialized(TableItem item, boolean initialized) {
        WidgetRemoteAdapter adapter = (WidgetRemoteAdapter)WidgetUtil.getAdapter(item);
        adapter.setInitialized(initialized);
    }

    private TableItemLCA() {
    }

    private static interface IRenderRunnable {
        public void run() throws IOException;
    }
}

