/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.presentations.util.IPresentablePartList;
import org.eclipse.ui.internal.presentations.util.TabOrder;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IPresentationSerializer;

public class LeftToRightTabOrder
extends TabOrder {
    private IPresentablePartList list;

    public LeftToRightTabOrder(IPresentablePartList list) {
        this.list = list;
    }

    @Override
    public void add(IPresentablePart newPart) {
        this.list.insert(newPart, this.list.size());
    }

    @Override
    public void addInitial(IPresentablePart newPart) {
        this.add(newPart);
    }

    @Override
    public void insert(IPresentablePart newPart, int index) {
        this.list.insert(newPart, index);
    }

    @Override
    public void remove(IPresentablePart removed) {
        this.list.remove(removed);
    }

    @Override
    public void select(IPresentablePart selected) {
        this.list.select(selected);
    }

    @Override
    public void move(IPresentablePart toMove, int newIndex) {
        this.list.move(toMove, newIndex);
    }

    @Override
    public IPresentablePart[] getPartList() {
        return this.list.getPartList();
    }

    @Override
    public void restoreState(IPresentationSerializer serializer, IMemento savedState) {
        IMemento[] parts = savedState.getChildren("part");
        int idx = 0;
        while (idx < parts.length) {
            IPresentablePart part;
            String id = parts[idx].getString("id");
            if (id != null && (part = serializer.getPart(id)) != null) {
                this.addInitial(part);
            }
            ++idx;
        }
    }

    @Override
    public void saveState(IPresentationSerializer context, IMemento memento) {
        List<IPresentablePart> parts = Arrays.asList(this.list.getPartList());
        for (IPresentablePart next : parts) {
            IMemento childMem = memento.createChild("part");
            childMem.putString("id", context.getId(next));
        }
    }
}

