/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.registry.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.equinox.http.registry.internal.ExtensionPointTracker;
import org.eclipse.equinox.http.registry.internal.HttpRegistryManager;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ResourceManager
implements ExtensionPointTracker.Listener {
    private static final String RESOURCES_EXTENSION_POINT = "org.eclipse.equinox.http.registry.resources";
    private static final String HTTPCONTEXT_NAME = "httpcontext-name";
    private static final String BASE_NAME = "base-name";
    private static final String ALIAS = "alias";
    private static final String RESOURCE = "resource";
    private static final String HTTPCONTEXT_ID = "httpcontextId";
    private static final String SERVICESELECTOR = "serviceSelector";
    private static final String CLASS = "class";
    private static final String FILTER = "filter";
    private ExtensionPointTracker tracker;
    private List<IConfigurationElement> registered = new ArrayList<IConfigurationElement>();
    private HttpRegistryManager httpRegistryManager;
    private ServiceReference<?> reference;

    public ResourceManager(HttpRegistryManager httpRegistryManager, ServiceReference<?> reference, IExtensionRegistry registry) {
        this.httpRegistryManager = httpRegistryManager;
        this.reference = reference;
        this.tracker = new ExtensionPointTracker(registry, RESOURCES_EXTENSION_POINT, this);
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    @Override
    public void added(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement serviceSelectorElement = elements[i];
            if (SERVICESELECTOR.equals(serviceSelectorElement.getName())) {
                Filter serviceSelector = null;
                String clazz = serviceSelectorElement.getAttribute(CLASS);
                if (clazz != null) {
                    try {
                        serviceSelector = (Filter)serviceSelectorElement.createExecutableExtension(CLASS);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                String filter = serviceSelectorElement.getAttribute(FILTER);
                if (filter == null) {
                    return;
                }
                try {
                    serviceSelector = FrameworkUtil.createFilter((String)filter);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                    return;
                }
                if (serviceSelector.match(this.reference)) break;
                return;
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            String alias;
            IConfigurationElement resourceElement = elements[i];
            if (RESOURCE.equals(resourceElement.getName()) && (alias = resourceElement.getAttribute(ALIAS)) != null) {
                String httpContextId;
                String baseName = resourceElement.getAttribute(BASE_NAME);
                if (baseName == null) {
                    baseName = "";
                }
                if ((httpContextId = resourceElement.getAttribute(HTTPCONTEXT_ID)) == null) {
                    httpContextId = resourceElement.getAttribute(HTTPCONTEXT_NAME);
                }
                if (httpContextId != null && httpContextId.indexOf(46) == -1) {
                    httpContextId = String.valueOf(resourceElement.getNamespaceIdentifier()) + "." + httpContextId;
                }
                if (this.httpRegistryManager.addResourcesContribution(alias, baseName, httpContextId, extension.getContributor())) {
                    this.registered.add(resourceElement);
                }
            }
            ++i;
        }
    }

    @Override
    public void removed(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement resourceElement = elements[i];
            if (this.registered.remove(resourceElement)) {
                String alias = resourceElement.getAttribute(ALIAS);
                this.httpRegistryManager.removeContribution(alias);
            }
            ++i;
        }
    }
}

