/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.fileupload.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.fileupload.FileDetails;
import org.eclipse.rap.fileupload.FileUploadEvent;
import org.eclipse.rap.fileupload.FileUploadHandler;

final class FileUploadTracker {
    private final FileUploadHandler handler;
    private final List<FileDetails> files;
    private long contentLength;
    private long bytesRead;
    private Exception exception;

    FileUploadTracker(FileUploadHandler handler) {
        this.handler = handler;
        this.files = new ArrayList<FileDetails>();
    }

    void addFile(FileDetails details) {
        this.files.add(details);
    }

    boolean isEmpty() {
        return this.files.isEmpty();
    }

    void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    void setBytesRead(long bytesRead) {
        this.bytesRead = bytesRead;
    }

    void setException(Exception exception) {
        this.exception = exception;
    }

    void handleProgress() {
        new InternalFileUploadEvent(this.handler).dispatchAsProgress();
    }

    void handleFinished() {
        new InternalFileUploadEvent(this.handler).dispatchAsFinished();
    }

    void handleFailed() {
        new InternalFileUploadEvent(this.handler).dispatchAsFailed();
    }

    private final class InternalFileUploadEvent
    extends FileUploadEvent {
        private static final long serialVersionUID = 1L;

        private InternalFileUploadEvent(FileUploadHandler source) {
            super(source);
        }

        @Override
        public FileDetails[] getFileDetails() {
            return FileUploadTracker.this.files.toArray(new FileDetails[0]);
        }

        @Override
        public long getContentLength() {
            return FileUploadTracker.this.contentLength;
        }

        @Override
        public long getBytesRead() {
            return FileUploadTracker.this.bytesRead;
        }

        @Override
        public Exception getException() {
            return FileUploadTracker.this.exception;
        }

        void dispatchAsProgress() {
            super.dispatchProgress();
        }

        void dispatchAsFinished() {
            super.dispatchFinished();
        }

        void dispatchAsFailed() {
            super.dispatchFailed();
        }
    }
}

