/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NebulaRichTextTab
extends ExampleTab {
    private RichTextEditor editor;
    private Button editableButton;
    private boolean reorderToolbarGroups;
    private boolean removeToolbarButtons;

    public NebulaRichTextTab() {
        super("Nebula RichText");
        this.setDefaultStyle(2048);
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048, true);
        this.createVisibilityButton();
        this.createEditableButton(parent);
        this.createReorderToolbarGroups(parent);
        this.createRemoveToolbarButtons(parent);
        this.createBgColorButton();
        this.createFontChooser();
        this.createText(parent);
        this.createDispose(parent);
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createRichTextEditor(parent);
        this.registerControl((Control)this.editor);
    }

    private void createRichTextEditor(Composite parent) {
        RichTextEditorConfiguration config = new RichTextEditorConfiguration();
        if (this.removeToolbarButtons) {
            config.removeDefaultToolbarButton(new String[]{"Subscript"});
            config.removeDefaultToolbarButton(new String[]{"Superscript"});
        }
        if (this.reorderToolbarGroups) {
            StringBuilder builder = new StringBuilder("[");
            builder.append("{\"name\":\"styles\"},");
            builder.append("{\"name\":\"colors\" },");
            builder.append("{\"name\":\"basicstyles\",\"groups\":[\"basicstyles\",\"cleanup\"]}");
            builder.append("]");
            config.setOption("toolbarGroups", (Object)builder.toString());
        }
        this.editor = new RichTextEditor(parent, config, this.getStyle());
        this.editor.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor.setFont(new Font((Device)parent.getDisplay(), "fantasy", 19, 0));
        this.editor.setText("Hello Fantasy Font");
        this.editor.setEditable(this.checkControl((Control)this.editableButton) ? this.editableButton.getSelection() : true);
    }

    private void createEditableButton(Composite parent) {
        this.editableButton = new Button(parent, 32);
        this.editableButton.setText("Editable");
        this.editableButton.setSelection(true);
        this.editableButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NebulaRichTextTab.this.editor.setEditable(NebulaRichTextTab.this.editableButton.getSelection());
            }
        });
    }

    private void createText(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Text");
        group.setLayout((Layout)new GridLayout(2, false));
        final Text setText = new Text((Composite)group, 2048);
        setText.setLayoutData((Object)new GridData(200, -1));
        Button setButton = new Button((Composite)group, 8);
        setButton.setText("Set");
        setButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NebulaRichTextTab.this.editor.setText(setText.getText());
            }
        });
        Button getButton = new Button((Composite)group, 8);
        getButton.setText("Get");
        getButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NebulaRichTextTab.this.log(NebulaRichTextTab.this.editor.getText());
            }
        });
    }

    private void createDispose(Composite parent) {
        Button disposeButton = new Button(parent, 8);
        disposeButton.setText("Dispose");
        disposeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NebulaRichTextTab.this.editor.dispose();
            }
        });
    }

    private void createReorderToolbarGroups(Composite parent) {
        final Button reorderButton = new Button(parent, 32);
        reorderButton.setText("Remove and reorder toolbar groups");
        reorderButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NebulaRichTextTab.this.reorderToolbarGroups = reorderButton.getSelection();
                NebulaRichTextTab.this.createNew();
            }
        });
    }

    private void createRemoveToolbarButtons(Composite parent) {
        final Button removeButton = new Button(parent, 32);
        removeButton.setText("Remove Subscript/Superscript toolbar buttons");
        removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NebulaRichTextTab.this.removeToolbarButtons = removeButton.getSelection();
                NebulaRichTextTab.this.createNew();
            }
        });
    }
}

