/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.widgets.ControlRemoteAdapter;
import org.eclipse.swt.internal.widgets.ICompositeAdapter;
import org.eclipse.swt.internal.widgets.compositekit.CompositeLCA;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public class Composite
extends Scrollable {
    private final ICompositeAdapter compositeAdapter;
    private Layout layout;
    int layoutCount;
    private final List<Control> children = new ArrayList<Control>();
    private Control[] tabList;
    int backgroundMode;

    Composite(Composite parent) {
        super(parent);
        this.compositeAdapter = new CompositeAdapter();
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
        this.compositeAdapter = new CompositeAdapter();
    }

    @Override
    void initState() {
        if ((this.style & 0x300) == 0) {
            this.addState(256);
        }
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this.children.toArray(new Control[0]);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ICompositeAdapter.class) {
            return (T)this.compositeAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)CompositeLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public void setLayoutDeferred(boolean defer) {
        this.checkWidget();
        if (!defer) {
            if (--this.layoutCount == 0 && (this.hasState(128) || this.hasState(32))) {
                this.updateLayout(true, true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout != null) {
            this.layout(changed, false);
        }
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout != null || all) {
            this.markLayout(changed, all);
            this.updateLayout(true, all);
        }
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        this.layout(changed, 0);
    }

    public void layout(Control[] changed, int flags) {
        this.checkWidget();
        if (changed != null) {
            int i = 0;
            while (i < changed.length) {
                Control control = changed[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                boolean ancestor = false;
                Composite composite = control._getParent();
                while (composite != null) {
                    boolean bl = ancestor = composite == this;
                    if (ancestor) break;
                    composite = composite._getParent();
                }
                if (!ancestor) {
                    this.error(32);
                }
                ++i;
            }
            int updateCount = 0;
            Composite[] update = new Composite[16];
            int i2 = 0;
            while (i2 < changed.length) {
                Control child = changed[i2];
                Composite composite = child._getParent();
                while (child != this) {
                    if (composite.layout != null) {
                        composite.addState(32);
                        if (!composite.layout.flushCache(child)) {
                            composite.addState(64);
                        }
                    }
                    if (updateCount == update.length) {
                        Composite[] newUpdate = new Composite[update.length + 16];
                        System.arraycopy(update, 0, newUpdate, 0, update.length);
                        update = newUpdate;
                    }
                    int n = updateCount++;
                    Composite composite2 = composite;
                    update[n] = composite2;
                    child = composite2;
                    composite = child._getParent();
                }
                ++i2;
            }
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            i2 = updateCount - 1;
            while (i2 >= 0) {
                update[i2].updateLayout(false);
                --i2;
            }
        } else {
            if (this.layout == null && (flags & 1) == 0) {
                return;
            }
            this.markLayout((flags & 2) != 0, (flags & 1) != 0);
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            this.updateLayout((flags & 1) != 0);
        }
    }

    @Override
    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.addState(32);
            if (changed) {
                this.addState(64);
            }
        }
        if (all) {
            for (Control child : this.children) {
                child.markLayout(changed, all);
            }
        }
    }

    void updateLayout(boolean all) {
        this.updateLayout(true, all);
    }

    @Override
    void updateLayout(boolean resize, boolean all) {
        Composite parent = this.findDeferredControl();
        if (parent != null) {
            parent.addState(128);
            return;
        }
        if (this.hasState(32)) {
            boolean changed = this.hasState(64);
            this.removeState(96);
            this.layout.layout(this, changed);
        }
        if (all) {
            this.removeState(128);
            for (Control child : this.children) {
                child.updateLayout(resize, all);
            }
        }
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this._getParent().findDeferredControl();
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        boolean hasChanged = changed;
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                this.removeState(64);
                size = this.layout.computeSize(this, wHint, hHint, hasChanged |= this.hasState(64));
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize();
            if (size.x == 0) {
                size.x = 64;
            }
            if (size.y == 0) {
                size.y = 64;
            }
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    public void changed(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control._getParent();
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite._getParent();
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        i = 0;
        while (i < changed.length) {
            Control child = changed[i];
            Composite composite = child._getParent();
            while (child != this) {
                if (composite.layout == null || !composite.layout.flushCache(child)) {
                    composite.addState(64);
                }
                child = composite;
                composite = child._getParent();
            }
            ++i;
        }
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public void setBackgroundMode(int mode) {
        this.checkWidget();
        this.backgroundMode = mode;
        for (Control child : this.children) {
            child.updateBackgroundMode();
        }
    }

    @Override
    void updateBackgroundMode() {
        super.updateBackgroundMode();
        for (Control child : this.children) {
            child.updateBackgroundMode();
        }
    }

    @Override
    void updateOrientation() {
        int orientation = this.style & 0x6000000;
        super.updateOrientation();
        for (Control child : this.children) {
            child.setOrientation(orientation);
        }
    }

    @Override
    public boolean setFocus() {
        this.checkWidget();
        for (Control child : this.children) {
            if (!child.setFocus()) continue;
            return true;
        }
        return super.setFocus();
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        Control[] newList = tabList;
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control._getParent() != this) {
                    this.error(32);
                }
                ++i;
            }
            newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
        }
        this.tabList = newList;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] result = this._getTabList();
        if (result == null) {
            int count = 0;
            for (Control child : this.children) {
                if (!child.isTabGroup()) continue;
                ++count;
            }
            result = new Control[count];
            int index = 0;
            for (Control child : this.children) {
                if (!child.isTabGroup()) continue;
                result[index++] = child;
            }
        }
        return result;
    }

    Control[] _getTabList() {
        if (this.tabList != null) {
            int count = 0;
            int i = 0;
            while (i < this.tabList.length) {
                if (!this.tabList[i].isDisposed()) {
                    ++count;
                }
                ++i;
            }
            if (count != this.tabList.length) {
                Control[] newList = new Control[count];
                int index = 0;
                int i2 = 0;
                while (i2 < this.tabList.length) {
                    if (!this.tabList[i2].isDisposed()) {
                        newList[index++] = this.tabList[i2];
                    }
                    ++i2;
                }
                this.tabList = newList;
            }
        }
        return this.tabList;
    }

    @Override
    boolean isTabGroup() {
        return true;
    }

    Point minimumSize() {
        Rectangle clientArea = this.getClientArea();
        int width = 0;
        int height = 0;
        for (Control child : this.children) {
            Rectangle rect = child.getBounds();
            width = Math.max(width, rect.x - clientArea.x + rect.width);
            height = Math.max(height, rect.y - clientArea.y + rect.height);
        }
        return new Point(width, height);
    }

    @Override
    void releaseChildren() {
        super.releaseChildren();
        ArrayList<Control> copy = new ArrayList<Control>(this.children);
        for (Control child : copy) {
            child.dispose();
        }
    }

    void addChild(Control control) {
        this.getRemoteAdapter().preserveChildren(this.children.toArray(new Control[0]));
        this.children.add(control);
    }

    void removeChild(Control control) {
        this.getRemoteAdapter().preserveChildren(this.children.toArray(new Control[0]));
        this.children.remove(control);
    }

    void moveAbove(Control control1, Control control2) {
        this.getRemoteAdapter().preserveChildren(this.children.toArray(new Control[0]));
        this.children.remove(control1);
        int index = control2 != null ? this.children.indexOf(control2) : 0;
        this.children.add(index, control1);
    }

    void moveBelow(Control control1, Control control2) {
        this.getRemoteAdapter().preserveChildren(this.children.toArray(new Control[0]));
        this.children.remove(control1);
        int index = control2 != null ? this.children.indexOf(control2) + 1 : this.children.size();
        this.children.add(index, control1);
    }

    @Override
    void notifyResize(Point oldSize) {
        if (!oldSize.equals(this.getSize()) || this.isLayoutNeeded()) {
            ProcessActionRunner.add(new Runnable(){

                @Override
                public void run() {
                    if (!Composite.this.isDisposed() && Composite.this.layout != null) {
                        Composite.this.markLayout(false, false);
                        Composite.this.updateLayout(false, false);
                    }
                }
            });
        }
        super.notifyResize(oldSize);
    }

    private boolean isLayoutNeeded() {
        return this.hasState(32);
    }

    @Override
    void reskinChildren(int flags) {
        super.reskinChildren(flags);
        for (Control child : this.children) {
            if (child == null) continue;
            child.reskin(flags);
        }
    }

    private ControlRemoteAdapter getRemoteAdapter() {
        return (ControlRemoteAdapter)this.getAdapter(RemoteAdapter.class);
    }

    private final class CompositeAdapter
    implements ICompositeAdapter,
    SerializableCompatibility {
        private CompositeAdapter() {
        }

        @Override
        public void markLayoutNeeded() {
            Composite.this.markLayout(false, false);
        }

        @Override
        public Iterable<Control> getChildren() {
            return Composite.this.children;
        }
    }
}

