/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

public class Token
implements CharSequence {
    protected final char[] ch;
    protected final int start;
    protected final int length;
    protected final int line;
    protected final int column;

    public Token(CharSequence cs) {
        if (cs instanceof Token) {
            Token ca = (Token)cs;
            this.ch = ca.ch;
            this.start = ca.start;
            this.length = ca.length;
            this.line = ca.line;
            this.column = ca.column;
        } else {
            this.ch = cs.toString().toCharArray();
            this.start = 0;
            this.length = this.ch.length;
            this.line = 0;
            this.column = 0;
        }
    }

    public Token(char[] _ch, int _start, int _length, int _line, int _col) {
        this.ch = _ch;
        this.start = _start;
        this.length = _length;
        this.line = _line;
        this.column = _col;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public int start() {
        return this.start;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.ch[this.start + index];
    }

    @Override
    public Token subSequence(int start, int end) {
        int line = this.line;
        int col = this.column;
        for (int i = this.start; i < this.start + start; ++i) {
            if (this.ch[i] == '\n') {
                ++line;
                col = 0;
                continue;
            }
            ++col;
        }
        return new Token(this.ch, this.start + start, end - start, line, col);
    }

    @Override
    public String toString() {
        return new String(this.ch, this.start, this.length);
    }

    public static boolean eq(CharSequence cs1, CharSequence cs2) {
        int l2;
        if (cs1 == cs2) {
            return true;
        }
        int l1 = cs1.length();
        if (l1 != (l2 = cs2.length())) {
            return false;
        }
        for (int i = 0; i < l1; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

