/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.application.Application;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.client.Client;
import org.eclipse.rap.rwt.client.WebClient;
import org.eclipse.rap.rwt.internal.SingletonManager;
import org.eclipse.rap.rwt.internal.application.ApplicationContextHelper;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.client.ClientSelector;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rap.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseId;
import org.eclipse.rap.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.service.UISessionBuilder;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.remote.Connection;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.rwt.testfixture.internal.FileUtil;
import org.eclipse.rap.rwt.testfixture.internal.TestHttpSession;
import org.eclipse.rap.rwt.testfixture.internal.TestMessage;
import org.eclipse.rap.rwt.testfixture.internal.TestRequest;
import org.eclipse.rap.rwt.testfixture.internal.TestResourceManager;
import org.eclipse.rap.rwt.testfixture.internal.TestResponse;
import org.eclipse.rap.rwt.testfixture.internal.TestServletContext;
import org.eclipse.rap.rwt.testfixture.internal.engine.ThemeManagerHelper;
import org.eclipse.swt.internal.widgets.WidgetRemoteAdapter;
import org.eclipse.swt.internal.widgets.displaykit.DisplayLCA;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public final class Fixture {
    private static final String HEAD = "head";
    private static final String OPERATIONS = "operations";
    private static final String SET = "set";
    private static final String CALL = "call";
    private static final String NOTIFY = "notify";
    public static final File TEMP_DIR = Fixture.createTempDir();
    public static final File WEB_CONTEXT_DIR = new File(TEMP_DIR, "testapp");
    public static final File WEB_CONTEXT_RWT_RESOURCES_DIR = new File(WEB_CONTEXT_DIR, "rwt-resources");
    public static final String IMAGE1 = "resources/images/image1.gif";
    public static final String IMAGE2 = "resources/images/image2.gif";
    public static final String IMAGE3 = "resources/images/image3.gif";
    public static final String IMAGE_100x50 = "resources/images/test-100x50.png";
    public static final String IMAGE_50x100 = "resources/images/test-50x100.png";
    private static final String SYS_PROP_USE_PERFORMANCE_OPTIMIZATIONS = "usePerformanceOptimizations";
    private static ServletContext servletContext;
    private static ApplicationContextImpl applicationContext;

    static {
        Fixture.setSkipResourceRegistration(Fixture.isPerformanceOptimizationsEnabled());
        Fixture.setSkipResourceDeletion(Fixture.isPerformanceOptimizationsEnabled());
    }

    public static ServletContext createServletContext() {
        servletContext = new TestServletContext();
        return servletContext;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static void disposeOfServletContext() {
        servletContext = null;
    }

    public static void setInitParameter(String name, String value) {
        Fixture.ensureServletContext();
        servletContext.setInitParameter(name, value);
    }

    public static void createApplicationContext() {
        Fixture.createApplicationContext(false);
    }

    public static void createApplicationContext(final boolean useDefaultResourceManager) {
        Fixture.ensureServletContext();
        Fixture.createWebContextDirectory();
        FixtureApplicationConfiguration config = new FixtureApplicationConfiguration();
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Fixture.class.getClassLoader());
            applicationContext = new ApplicationContextImpl(config, servletContext){

                protected ThemeManager createThemeManager() {
                    return ThemeManagerHelper.ensureThemeManager();
                }

                protected ResourceManager createResourceManager() {
                    if (useDefaultResourceManager) {
                        return super.createResourceManager();
                    }
                    return new TestResourceManager();
                }
            };
            applicationContext.attachToServletContext();
            SingletonManager.install((ApplicationContext)applicationContext);
            applicationContext.activate();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    public static void disposeOfApplicationContext() {
        applicationContext.deactivate();
        applicationContext.removeFromServletContext();
        Fixture.disposeOfServletContext();
        if (!Fixture.isPerformanceOptimizationsEnabled()) {
            Fixture.deleteWebContextDirectory();
        }
        applicationContext = null;
    }

    public static void createServiceContext() {
        TestRequest request = new TestRequest();
        ClientMessage message = Fixture.createEmptyMessage();
        request.setBody(message.toString());
        TestResponse response = new TestResponse();
        TestHttpSession session = Fixture.createTestSession();
        request.setSession(session);
        Fixture.createNewServiceContext(request, response);
        ProtocolUtil.setClientMessage((ClientMessage)message);
    }

    private static TestHttpSession createTestSession() {
        TestHttpSession result = new TestHttpSession();
        if (servletContext != null) {
            result.setServletContext(servletContext);
        }
        return result;
    }

    public static void disposeOfServiceContext() {
        ThemeManagerHelper.resetThemeManagerIfNeeded();
        HttpSession session = ContextProvider.getRequest().getSession();
        ContextProvider.disposeContext();
        session.invalidate();
    }

    public static void createWebContextDirectory() {
        WEB_CONTEXT_DIR.mkdirs();
    }

    public static void deleteWebContextDirectory() {
        if (WEB_CONTEXT_DIR.exists()) {
            FileUtil.delete(WEB_CONTEXT_DIR);
        }
    }

    public static void setUp() {
        Fixture.setUp(false);
    }

    public static void setUp(boolean useDefaultResourceManager) {
        Fixture.createApplicationContext(useDefaultResourceManager);
        Fixture.createServiceContext();
        Fixture.fakeClient((Client)new WebClient());
    }

    public static void tearDown() {
        Fixture.disposeOfServiceContext();
        Fixture.disposeOfApplicationContext();
        Fixture.disposeOfServletContext();
    }

    public static void readDataAndProcessAction(Display display) {
        DisplayLCA displayLCA = DisplayUtil.getLCA((Display)display);
        Fixture.fakePhase(PhaseId.READ_DATA);
        displayLCA.readData(display);
        Fixture.preserveWidgets();
        Fixture.fakePhase(PhaseId.PROCESS_ACTION);
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public static void readDataAndProcessAction(Widget widget) {
        WidgetLCA widgetLCA = WidgetUtil.getLCA((Widget)widget);
        Fixture.fakePhase(PhaseId.READ_DATA);
        widgetLCA.readData(widget);
        Fixture.fakePhase(PhaseId.PROCESS_ACTION);
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public static void markInitialized(Widget widget) {
        ((WidgetRemoteAdapter)WidgetUtil.getAdapter((Widget)widget)).setInitialized(true);
    }

    public static void markInitialized(Display display) {
        ((WidgetRemoteAdapter)DisplayUtil.getAdapter((Display)display)).setInitialized(true);
    }

    public static void preserveWidgets() {
        Display display = LifeCycleUtil.getSessionDisplay();
        DisplayLCA displayLCA = DisplayUtil.getLCA((Display)display);
        PhaseId bufferedPhaseId = CurrentPhase.get();
        Fixture.fakePhase(PhaseId.RENDER);
        displayLCA.clearPreserved(display);
        Fixture.fakePhase(PhaseId.READ_DATA);
        displayLCA.preserveValues(display);
        Fixture.fakePhase(bufferedPhaseId);
    }

    public static void clearPreserved() {
        Display display = LifeCycleUtil.getSessionDisplay();
        DisplayLCA displayLCA = DisplayUtil.getLCA((Display)display);
        PhaseId bufferedPhaseId = CurrentPhase.get();
        Fixture.fakePhase(PhaseId.RENDER);
        displayLCA.clearPreserved(display);
        Fixture.fakePhase(bufferedPhaseId);
    }

    public static TestMessage getProtocolMessage() {
        TestResponse response = (TestResponse)ContextProvider.getResponse();
        Fixture.finishResponse(response);
        return new TestMessage(JsonObject.readFrom((String)response.getContent()));
    }

    private static void finishResponse(TestResponse response) {
        if (response.getContent().length() == 0) {
            try {
                ContextProvider.getProtocolWriter().createMessage().toJson().writeTo((Writer)response.getWriter());
            }
            catch (IOException exception) {
                throw new IllegalStateException("Failed to get response writer", exception);
            }
        }
    }

    public static void fakeClient(Client client) {
        ContextProvider.getUISession().setAttribute(ClientSelector.SELECTED_CLIENT, (Object)client);
    }

    public static void fakeConnection(Connection connection) {
        ((UISessionImpl)ContextProvider.getUISession()).setConnection(connection);
    }

    public static TestRequest fakeNewRequest() {
        TestRequest request = Fixture.createNewRequest("POST");
        request.setContentType("application/json");
        request.setParameter("cid", Fixture.getConnectionId());
        ClientMessage emptyMessage = Fixture.createEmptyMessage();
        request.setBody(emptyMessage.toString());
        Fixture.createNewServiceContext(request, new TestResponse());
        ProtocolUtil.setClientMessage((ClientMessage)emptyMessage);
        Fixture.fakeResponseWriter();
        return request;
    }

    public static TestRequest fakeNewGetRequest() {
        TestRequest request = Fixture.createNewRequest("GET");
        Fixture.createNewServiceContext(request, new TestResponse());
        return request;
    }

    private static TestRequest createNewRequest(String method) {
        TestRequest request = new TestRequest();
        request.setMethod(method);
        request.setSession(ContextProvider.getRequest().getSession());
        return request;
    }

    private static void createNewServiceContext(HttpServletRequest request, HttpServletResponse response) {
        ContextProvider.disposeContext();
        ServiceContext serviceContext = new ServiceContext(request, response, applicationContext);
        serviceContext.setServiceStore(new ServiceStore());
        ContextProvider.setContext((ServiceContext)serviceContext);
        Fixture.ensureUISession(serviceContext);
    }

    private static ClientMessage createEmptyMessage() {
        return new ClientMessage(new JsonObject().add(HEAD, (JsonValue)new JsonObject()).add(OPERATIONS, (JsonValue)new JsonArray()));
    }

    private static String getConnectionId() {
        UISessionImpl uiSession = (UISessionImpl)ContextProvider.getUISession();
        return uiSession == null ? null : uiSession.getConnectionId();
    }

    public static void fakeHeadParameter(String key, long value) {
        Fixture.fakeHeadParameter(key, JsonValue.valueOf((long)value));
    }

    public static void fakeHeadParameter(String key, boolean value) {
        Fixture.fakeHeadParameter(key, JsonValue.valueOf((boolean)value));
    }

    public static void fakeHeadParameter(String key, String value) {
        Fixture.fakeHeadParameter(key, JsonValue.valueOf((String)value));
    }

    public static void fakeHeadParameter(String key, JsonValue value) {
        TestRequest request = (TestRequest)ContextProvider.getRequest();
        String json = request.getBody();
        try {
            JsonObject message = JsonObject.readFrom((String)json);
            JsonObject header = message.get(HEAD).asObject();
            header.add(key, value);
            request.setBody(message.toString());
            ProtocolUtil.setClientMessage((ClientMessage)new ClientMessage(message));
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to add header parameter", exception);
        }
    }

    public static void fakeSetProperty(String target, String propertyName, long propertyValue) {
        Fixture.fakeSetProperty(target, propertyName, JsonValue.valueOf((long)propertyValue));
    }

    public static void fakeSetProperty(String target, String propertyName, boolean propertyValue) {
        Fixture.fakeSetProperty(target, propertyName, JsonValue.valueOf((boolean)propertyValue));
    }

    public static void fakeSetProperty(String target, String propertyName, String propertyValue) {
        Fixture.fakeSetProperty(target, propertyName, JsonValue.valueOf((String)propertyValue));
    }

    public static void fakeSetProperty(String target, String key, JsonValue value) {
        Fixture.fakeSetOperation(target, new JsonObject().add(key, value));
    }

    public static void fakeSetOperation(String target, JsonObject properties) {
        TestRequest request = (TestRequest)ContextProvider.getRequest();
        String json = request.getBody();
        try {
            JsonObject message = JsonObject.readFrom((String)json);
            JsonArray operations = message.get(OPERATIONS).asArray();
            JsonArray newOperation = new JsonArray();
            newOperation.add(SET);
            newOperation.add(target);
            newOperation.add((JsonValue)(properties != null ? properties : new JsonObject()));
            operations.add((JsonValue)newOperation);
            request.setBody(message.toString());
            ProtocolUtil.setClientMessage((ClientMessage)new ClientMessage(message));
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to add set operation", exception);
        }
    }

    public static void fakeNotifyOperation(String target, String eventName, JsonObject properties) {
        TestRequest request = (TestRequest)ContextProvider.getRequest();
        String json = request.getBody();
        try {
            JsonObject message = JsonObject.readFrom((String)json);
            JsonArray operations = message.get(OPERATIONS).asArray();
            JsonArray newOperation = new JsonArray();
            newOperation.add(NOTIFY);
            newOperation.add(target);
            newOperation.add(eventName);
            newOperation.add((JsonValue)(properties != null ? properties : new JsonObject()));
            operations.add((JsonValue)newOperation);
            request.setBody(message.toString());
            ProtocolUtil.setClientMessage((ClientMessage)new ClientMessage(message));
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to add notify operation", exception);
        }
    }

    public static void fakeCallOperation(String target, String methodName, JsonObject parameters) {
        TestRequest request = (TestRequest)ContextProvider.getRequest();
        String json = request.getBody();
        try {
            JsonObject message = JsonObject.readFrom((String)json);
            JsonArray operations = message.get(OPERATIONS).asArray();
            JsonArray newOperation = new JsonArray();
            newOperation.add(CALL);
            newOperation.add(target);
            newOperation.add(methodName);
            newOperation.add((JsonValue)(parameters != null ? parameters : new JsonObject()));
            operations.add((JsonValue)newOperation);
            request.setBody(message.toString());
            ProtocolUtil.setClientMessage((ClientMessage)new ClientMessage(message));
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to add call operation", exception);
        }
    }

    public static void fakeResponseWriter() {
        TestResponse testResponse = (TestResponse)ContextProvider.getResponse();
        testResponse.clearContent();
        ContextProvider.getContext().resetProtocolWriter();
    }

    public static void fakePhase(PhaseId phase) {
        CurrentPhase.set((PhaseId)phase);
    }

    public static void executeLifeCycleFromServerThread() {
        IUIThreadHolder threadHolder = Fixture.registerCurrentThreadAsUIThreadHolder();
        Thread serverThread = Fixture.fakeRequestThread(threadHolder);
        Fixture.simulateRequest(threadHolder, serverThread);
        RWTLifeCycle lifeCycle = (RWTLifeCycle)ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle();
        while (LifeCycleUtil.getSessionDisplay().readAndDispatch()) {
        }
        lifeCycle.sleep();
    }

    public static void replaceServiceStore(ServiceStore serviceStore) {
        HttpServletRequest request = ContextProvider.getRequest();
        HttpServletResponse response = ContextProvider.getResponse();
        ContextProvider.disposeContext();
        ServiceContext serviceContext = new ServiceContext(request, response, applicationContext);
        if (serviceStore != null) {
            serviceContext.setServiceStore(serviceStore);
        }
        ContextProvider.setContext((ServiceContext)serviceContext);
        Fixture.ensureUISession(serviceContext);
    }

    private static void ensureUISession(ServiceContext serviceContext) {
        String cid;
        HttpServletRequest request = serviceContext.getRequest();
        HttpSession httpSession = request.getSession(true);
        UISessionImpl uiSession = UISessionImpl.getInstanceFromSession((HttpSession)httpSession, (String)(cid = request.getParameter("cid")));
        if (uiSession == null) {
            uiSession = new UISessionBuilder(serviceContext).buildUISession();
        }
        serviceContext.setUISession((UISession)uiSession);
    }

    public static void setSkipResourceRegistration(boolean skip) {
        ApplicationContextHelper.setSkipResoureRegistration(skip);
    }

    public static void resetSkipResourceRegistration() {
        ApplicationContextHelper.setSkipResoureRegistration(Fixture.isPerformanceOptimizationsEnabled());
    }

    public static void setSkipResourceDeletion(boolean skip) {
        ApplicationContextHelper.setSkipResoureDeletion(skip);
    }

    public static void resetSkipResourceDeletion() {
        ApplicationContextHelper.setSkipResoureDeletion(Fixture.isPerformanceOptimizationsEnabled());
    }

    public static void copyTestResource(String resourceName, File destination) throws IOException {
        ClassLoader loader = Fixture.class.getClassLoader();
        InputStream is = loader.getResourceAsStream(resourceName);
        if (is == null) {
            throw new IllegalArgumentException("Resource could not be found: " + resourceName);
        }
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            FileOutputStream out = new FileOutputStream(destination);
            try (BufferedOutputStream bout = new BufferedOutputStream(out);){
                int c = bis.read();
                while (c != -1) {
                    bout.write(c);
                    c = bis.read();
                }
            }
        }
    }

    private static void ensureServletContext() {
        if (servletContext == null) {
            Fixture.createServletContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void simulateRequest(IUIThreadHolder threadHolder, Thread serverThread) {
        RWTLifeCycle lifeCycle = (RWTLifeCycle)ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle();
        Object object = threadHolder.getLock();
        synchronized (object) {
            serverThread.start();
            try {
                lifeCycle.sleep();
            }
            catch (ThreadDeath e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Thread fakeRequestThread(final IUIThreadHolder threadHolder) {
        final RWTLifeCycle lifeCycle = (RWTLifeCycle)ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle();
        final ServiceContext context = ContextProvider.getContext();
        Thread result = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = threadHolder.getLock();
                synchronized (object) {
                    ContextProvider.setContext((ServiceContext)context);
                    try {
                        try {
                            lifeCycle.execute();
                            lifeCycle.setPhaseOrder(null);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        ContextProvider.releaseContextHolder();
                        threadHolder.notifyAll();
                    }
                }
            }
        }, "ServerThread");
        return result;
    }

    private static IUIThreadHolder registerCurrentThreadAsUIThreadHolder() {
        IUIThreadHolder result = new IUIThreadHolder(){
            private final Thread thread = Thread.currentThread();

            public void setServiceContext(ServiceContext serviceContext) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void switchThread() {
                Object object = this.getLock();
                synchronized (object) {
                    this.notifyAll();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void updateServiceContext() {
            }

            public void terminateThread() {
            }

            public Thread getThread() {
                return this.thread;
            }

            public Object getLock() {
                return this;
            }
        };
        LifeCycleUtil.setUIThread((UISession)ContextProvider.getUISession(), (IUIThreadHolder)result);
        return result;
    }

    private static boolean isPerformanceOptimizationsEnabled() {
        return Boolean.getBoolean(SYS_PROP_USE_PERFORMANCE_OPTIMIZATIONS);
    }

    private static File createTempDir() {
        String subDirName;
        File globalTmpDir = new File(System.getProperty("java.io.tmpdir"));
        File tmpDir = new File(globalTmpDir, subDirName = "rap-test-" + Long.toHexString(System.currentTimeMillis()));
        if (!tmpDir.mkdir()) {
            String message = "Failed to create temp directory: " + tmpDir.getAbsolutePath();
            throw new IllegalStateException(message);
        }
        return tmpDir;
    }

    private Fixture() {
    }

    private static class FixtureApplicationConfiguration
    implements ApplicationConfiguration {
        private FixtureApplicationConfiguration() {
        }

        public void configure(Application application) {
            application.setOperationMode(Application.OperationMode.SWT_COMPATIBILITY);
        }
    }
}

