/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CheckFrameAnalyzer<V extends Value>
extends Analyzer<V> {
    private final Interpreter<V> interpreter;
    private InsnList insnList;
    private int currentLocals;

    CheckFrameAnalyzer(Interpreter<V> interpreter) {
        super(interpreter);
        this.interpreter = interpreter;
    }

    protected void init(String owner, MethodNode method) throws AnalyzerException {
        this.insnList = method.instructions;
        this.currentLocals = Type.getArgumentsAndReturnSizes((String)method.desc) >> 2;
        if ((method.access & 8) != 0) {
            --this.currentLocals;
        }
        Frame[] frames = this.getFrames();
        Frame currentFrame = frames[0];
        this.expandFrames(owner, method, currentFrame);
        for (int insnIndex = 0; insnIndex < this.insnList.size(); ++insnIndex) {
            Frame oldFrame = frames[insnIndex];
            AbstractInsnNode insnNode = null;
            try {
                insnNode = method.instructions.get(insnIndex);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.checkFrame(insnIndex + 1, oldFrame, false);
                } else {
                    LabelNode label;
                    int i;
                    currentFrame.init(oldFrame).execute(insnNode, this.interpreter);
                    if (insnNode instanceof JumpInsnNode) {
                        if (insnOpcode == 168) {
                            throw new AnalyzerException(insnNode, "JSR instructions are unsupported");
                        }
                        JumpInsnNode jumpInsn = (JumpInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf((AbstractInsnNode)jumpInsn.label);
                        this.checkFrame(targetInsnIndex, currentFrame, true);
                        if (insnOpcode == 167) {
                            this.endControlFlow(insnIndex);
                        } else {
                            this.checkFrame(insnIndex + 1, currentFrame, false);
                        }
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf((AbstractInsnNode)lookupSwitchInsn.dflt);
                        this.checkFrame(targetInsnIndex, currentFrame, true);
                        for (i = 0; i < lookupSwitchInsn.labels.size(); ++i) {
                            label = (LabelNode)lookupSwitchInsn.labels.get(i);
                            targetInsnIndex = this.insnList.indexOf((AbstractInsnNode)label);
                            currentFrame.initJumpTarget(insnOpcode, label);
                            this.checkFrame(targetInsnIndex, currentFrame, true);
                        }
                        this.endControlFlow(insnIndex);
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)insnNode;
                        int targetInsnIndex = this.insnList.indexOf((AbstractInsnNode)tableSwitchInsn.dflt);
                        currentFrame.initJumpTarget(insnOpcode, tableSwitchInsn.dflt);
                        this.checkFrame(targetInsnIndex, currentFrame, true);
                        this.newControlFlowEdge(insnIndex, targetInsnIndex);
                        for (i = 0; i < tableSwitchInsn.labels.size(); ++i) {
                            label = (LabelNode)tableSwitchInsn.labels.get(i);
                            currentFrame.initJumpTarget(insnOpcode, label);
                            targetInsnIndex = this.insnList.indexOf((AbstractInsnNode)label);
                            this.checkFrame(targetInsnIndex, currentFrame, true);
                        }
                        this.endControlFlow(insnIndex);
                    } else {
                        if (insnOpcode == 169) {
                            throw new AnalyzerException(insnNode, "RET instructions are unsupported");
                        }
                        if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                            this.checkFrame(insnIndex + 1, currentFrame, false);
                        } else {
                            this.endControlFlow(insnIndex);
                        }
                    }
                }
                List insnHandlers = this.getHandlers(insnIndex);
                if (insnHandlers != null) {
                    for (TryCatchBlockNode tryCatchBlock : insnHandlers) {
                        Type catchType = tryCatchBlock.type == null ? Type.getObjectType((String)"java/lang/Throwable") : Type.getObjectType((String)tryCatchBlock.type);
                        Frame handler = this.newFrame(oldFrame);
                        handler.clearStack();
                        handler.push(this.interpreter.newExceptionValue(tryCatchBlock, handler, catchType));
                        this.checkFrame(this.insnList.indexOf((AbstractInsnNode)tryCatchBlock.handler), handler, true);
                    }
                }
                if (this.hasNextJvmInsnOrFrame(insnIndex)) continue;
                break;
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction " + insnIndex + ": " + e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insnIndex + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void expandFrames(String owner, MethodNode method, Frame<V> initialFrame) throws AnalyzerException {
        int lastJvmOrFrameInsnIndex = -1;
        Frame<V> currentFrame = initialFrame;
        int currentInsnIndex = 0;
        for (AbstractInsnNode insnNode : method.instructions) {
            if (insnNode instanceof FrameNode) {
                try {
                    currentFrame = this.expandFrame(owner, currentFrame, (FrameNode)insnNode);
                }
                catch (AnalyzerException e) {
                    throw new AnalyzerException(e.node, "Error at instruction " + currentInsnIndex + ": " + e.getMessage(), (Throwable)e);
                }
                for (int index = lastJvmOrFrameInsnIndex + 1; index <= currentInsnIndex; ++index) {
                    this.getFrames()[index] = currentFrame;
                }
            }
            if (CheckFrameAnalyzer.isJvmInsnNode(insnNode) || insnNode instanceof FrameNode) {
                lastJvmOrFrameInsnIndex = currentInsnIndex;
            }
            ++currentInsnIndex;
        }
    }

    private Frame<V> expandFrame(String owner, Frame<V> previousFrame, FrameNode frameNode) throws AnalyzerException {
        Frame frame = this.newFrame(previousFrame);
        List locals = frameNode.local == null ? Collections.emptyList() : frameNode.local;
        int currentLocal = this.currentLocals;
        switch (frameNode.type) {
            case -1: 
            case 0: {
                currentLocal = 0;
            }
            case 1: {
                for (Object type : locals) {
                    V value = this.newFrameValue(owner, frameNode, type);
                    if (currentLocal + value.getSize() > frame.getLocals()) {
                        throw new AnalyzerException((AbstractInsnNode)frameNode, "Cannot append more locals than maxLocals");
                    }
                    frame.setLocal(currentLocal++, value);
                    if (value.getSize() != 2) continue;
                    frame.setLocal(currentLocal++, this.interpreter.newValue(null));
                }
                break;
            }
            case 2: {
                for (Object unusedType : locals) {
                    if (currentLocal <= 0) {
                        throw new AnalyzerException((AbstractInsnNode)frameNode, "Cannot chop more locals than defined");
                    }
                    if (currentLocal > 1 && frame.getLocal(currentLocal - 2).getSize() == 2) {
                        currentLocal -= 2;
                        continue;
                    }
                    --currentLocal;
                }
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new AnalyzerException((AbstractInsnNode)frameNode, "Illegal frame type " + frameNode.type);
            }
        }
        this.currentLocals = currentLocal;
        while (currentLocal < frame.getLocals()) {
            frame.setLocal(currentLocal++, this.interpreter.newValue(null));
        }
        List stack = frameNode.stack == null ? Collections.emptyList() : frameNode.stack;
        frame.clearStack();
        for (Object type : stack) {
            frame.push(this.newFrameValue(owner, frameNode, type));
        }
        return frame;
    }

    private V newFrameValue(String owner, FrameNode frameNode, Object type) throws AnalyzerException {
        if (type == Opcodes.TOP) {
            return (V)this.interpreter.newValue(null);
        }
        if (type == Opcodes.INTEGER) {
            return (V)this.interpreter.newValue(Type.INT_TYPE);
        }
        if (type == Opcodes.FLOAT) {
            return (V)this.interpreter.newValue(Type.FLOAT_TYPE);
        }
        if (type == Opcodes.LONG) {
            return (V)this.interpreter.newValue(Type.LONG_TYPE);
        }
        if (type == Opcodes.DOUBLE) {
            return (V)this.interpreter.newValue(Type.DOUBLE_TYPE);
        }
        if (type == Opcodes.NULL) {
            return (V)this.interpreter.newOperation((AbstractInsnNode)new InsnNode(1));
        }
        if (type == Opcodes.UNINITIALIZED_THIS) {
            return (V)this.interpreter.newValue(Type.getObjectType((String)owner));
        }
        if (type instanceof String) {
            return (V)this.interpreter.newValue(Type.getObjectType((String)((String)type)));
        }
        if (type instanceof LabelNode) {
            LabelNode referencedNode;
            for (referencedNode = (LabelNode)type; referencedNode != null && !CheckFrameAnalyzer.isJvmInsnNode((AbstractInsnNode)referencedNode); referencedNode = referencedNode.getNext()) {
            }
            if (referencedNode == null || referencedNode.getOpcode() != 187) {
                throw new AnalyzerException((AbstractInsnNode)frameNode, "LabelNode does not designate a NEW instruction");
            }
            return (V)this.interpreter.newValue(Type.getObjectType((String)((TypeInsnNode)referencedNode).desc));
        }
        throw new AnalyzerException((AbstractInsnNode)frameNode, "Illegal stack map frame value " + type);
    }

    private void checkFrame(int insnIndex, Frame<V> frame, boolean requireFrame) throws AnalyzerException {
        Frame oldFrame = this.getFrames()[insnIndex];
        if (oldFrame == null) {
            if (requireFrame) {
                throw new AnalyzerException(null, "Expected stack map frame at instruction " + insnIndex);
            }
            this.getFrames()[insnIndex] = this.newFrame(frame);
        } else {
            String error = this.checkMerge(frame, oldFrame);
            if (error != null) {
                throw new AnalyzerException(null, "Stack map frame incompatible with frame at instruction " + insnIndex + " (" + error + ")");
            }
        }
    }

    private String checkMerge(Frame<V> srcFrame, Frame<V> dstFrame) {
        int numLocals = srcFrame.getLocals();
        if (numLocals != dstFrame.getLocals()) {
            throw new AssertionError();
        }
        for (int i = 0; i < numLocals; ++i) {
            Value v = this.interpreter.merge(srcFrame.getLocal(i), dstFrame.getLocal(i));
            if (v.equals(dstFrame.getLocal(i))) continue;
            return "incompatible types at local " + i + ": " + srcFrame.getLocal(i) + " and " + dstFrame.getLocal(i);
        }
        int numStack = srcFrame.getStackSize();
        if (numStack != dstFrame.getStackSize()) {
            return "incompatible stack heights";
        }
        for (int i = 0; i < numStack; ++i) {
            Value v = this.interpreter.merge(srcFrame.getStack(i), dstFrame.getStack(i));
            if (v.equals(dstFrame.getStack(i))) continue;
            return "incompatible types at stack item " + i + ": " + srcFrame.getStack(i) + " and " + dstFrame.getStack(i);
        }
        return null;
    }

    private void endControlFlow(int insnIndex) throws AnalyzerException {
        if (this.hasNextJvmInsnOrFrame(insnIndex) && this.getFrames()[insnIndex + 1] == null) {
            throw new AnalyzerException(null, "Expected stack map frame at instruction " + (insnIndex + 1));
        }
    }

    private boolean hasNextJvmInsnOrFrame(int insnIndex) {
        for (AbstractInsnNode insn = this.insnList.get(insnIndex).getNext(); insn != null; insn = insn.getNext()) {
            if (!CheckFrameAnalyzer.isJvmInsnNode(insn) && !(insn instanceof FrameNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJvmInsnNode(AbstractInsnNode insnNode) {
        return insnNode.getOpcode() >= 0;
    }
}

