/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.translation;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class TranslationService {
    public static final String LOCALE = "org.eclipse.e4.core.locale";
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    @Inject
    @Named(value="org.eclipse.e4.core.locale")
    protected Locale locale;

    public String translate(String key, String contributorURI) {
        return key;
    }

    protected String getResourceString(String key, ResourceBundle resourceBundle) {
        String dflt;
        String s = key.trim();
        if (!s.startsWith(KEY_PREFIX, 0)) {
            return s;
        }
        if (s.startsWith(KEY_DOUBLE_PREFIX, 0)) {
            return s.substring(1);
        }
        int ix = s.indexOf(32);
        String rbKey = ix == -1 ? s : s.substring(0, ix);
        String string = dflt = ix == -1 ? s : s.substring(ix + 1);
        if (resourceBundle == null) {
            return dflt;
        }
        try {
            return resourceBundle.getString(rbKey.substring(1));
        }
        catch (MissingResourceException missingResourceException) {
            return dflt;
        }
    }
}

