/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class SizeLimitHandler
extends Handler.Wrapper {
    private final long _requestLimit;
    private final long _responseLimit;
    private long _read = 0L;
    private long _written = 0L;

    public SizeLimitHandler(long requestLimit, long responseLimit) {
        this._requestLimit = requestLimit;
        this._responseLimit = responseLimit;
    }

    @Override
    public boolean handle(final Request request, Response response, Callback callback) throws Exception {
        HttpField contentLengthField = request.getHeaders().getField(HttpHeader.CONTENT_LENGTH);
        if (contentLengthField != null) {
            long contentLength = contentLengthField.getLongValue();
            if (this._requestLimit >= 0L && contentLength > this._requestLimit) {
                String s = "Request body is too large: " + contentLength + ">" + this._requestLimit;
                Response.writeError(request, response, callback, 413, s);
                return true;
            }
        }
        final HttpFields.Mutable.Wrapper httpFields = new HttpFields.Mutable.Wrapper(response.getHeaders()){

            public HttpField onAddField(HttpField field) {
                if (field.getHeader().is(HttpHeader.CONTENT_LENGTH.asString())) {
                    long contentLength = field.getLongValue();
                    if (SizeLimitHandler.this._responseLimit >= 0L && contentLength > SizeLimitHandler.this._responseLimit) {
                        throw new HttpException.RuntimeException(500, "Response body is too large: " + contentLength + ">" + SizeLimitHandler.this._responseLimit);
                    }
                }
                return super.onAddField(field);
            }
        };
        response = new Response.Wrapper(request, response){

            @Override
            public HttpFields.Mutable getHeaders() {
                return httpFields;
            }
        };
        request.addHttpStreamWrapper(httpStream -> new HttpStream.Wrapper((HttpStream)httpStream){

            @Override
            public Content.Chunk read() {
                Content.Chunk chunk = super.read();
                if (chunk == null) {
                    return null;
                }
                if (chunk.getFailure() != null) {
                    return chunk;
                }
                ByteBuffer content = chunk.getByteBuffer();
                if (content != null && content.remaining() > 0) {
                    SizeLimitHandler.this._read += (long)content.remaining();
                    if (SizeLimitHandler.this._requestLimit >= 0L && SizeLimitHandler.this._read > SizeLimitHandler.this._requestLimit) {
                        BadMessageException e = new BadMessageException(413, "Request body is too large: " + SizeLimitHandler.this._read + ">" + SizeLimitHandler.this._requestLimit);
                        request.fail((Throwable)e);
                        return null;
                    }
                }
                return chunk;
            }

            @Override
            public void send(MetaData.Request request2, MetaData.Response response, boolean last, ByteBuffer content, Callback callback) {
                if (content != null && content.remaining() > 0) {
                    if (SizeLimitHandler.this._responseLimit >= 0L && SizeLimitHandler.this._written + (long)content.remaining() > SizeLimitHandler.this._responseLimit) {
                        callback.failed((Throwable)new HttpException.RuntimeException(500, "Response body is too large: " + SizeLimitHandler.this._written + content.remaining() + ">" + SizeLimitHandler.this._responseLimit));
                        return;
                    }
                    SizeLimitHandler.this._written += (long)content.remaining();
                }
                super.send(request2, response, last, content, callback);
            }
        });
        return super.handle(request, response, callback);
    }
}

