/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ConditionalHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class QoSHandler
extends ConditionalHandler.Abstract {
    private static final Logger LOG = LoggerFactory.getLogger(QoSHandler.class);
    private static final String EXPIRED_ATTRIBUTE_NAME = QoSHandler.class.getName() + ".expired";
    private final AtomicInteger state = new AtomicInteger();
    private final Map<Integer, Queue<Entry>> queues = new ConcurrentHashMap<Integer, Queue<Entry>>();
    private final Set<Integer> priorities = new ConcurrentSkipListSet(Comparator.reverseOrder());
    private CyclicTimeouts<Entry> timeouts;
    private int maxRequests;
    private Duration maxSuspend = Duration.ZERO;

    public QoSHandler() {
        this((Handler)null);
    }

    public QoSHandler(Handler handler) {
        super(false, handler);
    }

    @ManagedAttribute(value="The maximum number of concurrent requests", readonly=true)
    public int getMaxRequestCount() {
        return this.maxRequests;
    }

    public void setMaxRequestCount(int maxRequests) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot change maxRequests: " + String.valueOf(this));
        }
        this.maxRequests = maxRequests;
    }

    public Duration getMaxSuspend() {
        return this.maxSuspend;
    }

    public void setMaxSuspend(Duration maxSuspend) {
        if (maxSuspend.isNegative()) {
            throw new IllegalArgumentException("Invalid maxSuspend duration");
        }
        this.maxSuspend = maxSuspend;
    }

    @ManagedAttribute(value="The number of suspended requests")
    public long getSuspendedRequestCount() {
        int permits = this.state.get();
        return Math.max(0, -permits);
    }

    @Override
    protected void doStart() throws Exception {
        this.timeouts = new Timeouts(this.getServer().getScheduler());
        this.addBean(this.timeouts);
        int maxRequests = this.getMaxRequestCount();
        if (maxRequests <= 0) {
            ThreadPool threadPool = this.getServer().getThreadPool();
            if (threadPool instanceof ThreadPool.SizedThreadPool) {
                ThreadPool.SizedThreadPool sized = (ThreadPool.SizedThreadPool)threadPool;
                maxRequests = sized.getMaxThreads() / 2;
            } else {
                maxRequests = ProcessorUtils.availableProcessors();
            }
            this.setMaxRequestCount(maxRequests);
        }
        this.state.set(maxRequests);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} initialized maxRequests={}", (Object)this, (Object)maxRequests);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.timeouts);
        this.timeouts.destroy();
    }

    @Override
    public boolean onConditionsMet(Request request, Response response, Callback callback) throws Exception {
        int permits;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} handling {}", (Object)this, (Object)request);
        }
        if ((permits = this.state.getAndDecrement()) > 0) {
            return this.handleWithPermit(request, response, callback);
        }
        if (request.getAttribute(EXPIRED_ATTRIBUTE_NAME) != null) {
            this.state.getAndIncrement();
            QoSHandler.notAvailable(response, callback);
        } else {
            this.suspend(request, response, callback);
        }
        return true;
    }

    @Override
    protected boolean onConditionsNotMet(Request request, Response response, Callback callback) throws Exception {
        return this.nextHandler(request, response, callback);
    }

    private static void notAvailable(Response response, Callback callback) {
        response.setStatus(503);
        if (response.isCommitted()) {
            callback.failed((Throwable)new IllegalStateException("Response already committed"));
        } else {
            response.write(true, null, callback);
        }
    }

    protected int getPriority(Request request) {
        return 0;
    }

    protected void failSuspended(Request request, Response response, Callback callback, int status, Throwable failure) {
        Response.writeError(request, response, callback, status, null, failure);
    }

    private boolean handleWithPermit(Request request, Response response, Callback callback) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} forwarding {}", (Object)this, (Object)request);
        }
        request.addHttpStreamWrapper(stream -> new Resumer((HttpStream)stream, request));
        return this.nextHandler(request, response, callback);
    }

    private void suspend(Request request, Response response, Callback callback) {
        int priority = Math.max(0, this.getPriority(request));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} suspending priority={} {}", new Object[]{this, priority, request});
        }
        Entry entry = new Entry(request, response, callback, priority);
        this.queues.compute(priority, (k, v) -> {
            if (v == null) {
                this.priorities.add(priority);
                v = new ConcurrentLinkedQueue<Entry>();
            }
            v.offer(entry);
            return v;
        });
        this.timeouts.schedule((CyclicTimeouts.Expirable)entry);
    }

    private void resume() {
        int permits = this.state.getAndIncrement();
        if (permits >= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} no suspended requests to resume", (Object)this);
            }
            return;
        }
        while (!this.resumeSuspended()) {
            Thread.onSpinWait();
        }
        return;
    }

    private boolean resumeSuspended() {
        for (Integer priority : this.priorities) {
            Queue<Entry> queue = this.queues.get(priority);
            if (queue == null) {
                return false;
            }
            Entry entry = queue.poll();
            if (entry == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} resuming {}", (Object)this, (Object)entry.request);
            }
            this.getServer().getThreadPool().execute((Runnable)entry);
            return true;
        }
        return false;
    }

    private class Timeouts
    extends CyclicTimeouts<Entry> {
        private Timeouts(Scheduler scheduler) {
            super(scheduler);
        }

        protected Iterator<Entry> iterator() {
            return QoSHandler.this.queues.values().stream().flatMap(Collection::stream).iterator();
        }

        protected boolean onExpired(Entry entry) {
            entry.expire();
            return false;
        }
    }

    private class Entry
    implements CyclicTimeouts.Expirable,
    Runnable {
        private final Request request;
        private final Response response;
        private final Callback callback;
        private final int priority;
        private final long expireNanoTime;

        private Entry(Request request, Response response, Callback callback, int priority) {
            this.request = request;
            this.response = response;
            this.callback = callback;
            this.priority = priority;
            Duration maxSuspend = QoSHandler.this.getMaxSuspend();
            long suspendNanos = NanoTime.now() + maxSuspend.toNanos();
            if (suspendNanos == Long.MAX_VALUE) {
                --suspendNanos;
            }
            this.expireNanoTime = maxSuspend.isZero() ? Long.MAX_VALUE : suspendNanos;
        }

        public long getExpireNanoTime() {
            return this.expireNanoTime;
        }

        private void expire() {
            boolean removed = QoSHandler.this.queues.get(this.priority).remove(this);
            if (removed) {
                QoSHandler.this.state.getAndIncrement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} timeout {}", (Object)QoSHandler.this, (Object)this.request);
                }
                this.request.setAttribute(EXPIRED_ATTRIBUTE_NAME, true);
                QoSHandler.this.failSuspended(this.request, this.response, this.callback, 503, new TimeoutException());
            }
        }

        @Override
        public void run() {
            try {
                boolean handled = QoSHandler.this.handleWithPermit(this.request, this.response, this.callback);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} handled={} {}", new Object[]{QoSHandler.this, handled, this.request});
                }
                if (!handled) {
                    QoSHandler.this.failSuspended(this.request, this.response, this.callback, 404, null);
                }
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} failed {}", new Object[]{QoSHandler.this, this.request, x});
                }
                QoSHandler.this.failSuspended(this.request, this.response, this.callback, 500, x);
            }
        }
    }

    private class Resumer
    extends HttpStream.Wrapper {
        private final Request request;

        private Resumer(HttpStream wrapped, Request request) {
            super(wrapped);
            this.request = request;
        }

        @Override
        public void succeeded() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} succeeded {}", (Object)QoSHandler.this, (Object)this.request);
            }
            QoSHandler.this.resume();
        }

        @Override
        public void failed(Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} failed {}", new Object[]{QoSHandler.this, this.request, x});
            }
            QoSHandler.this.resume();
        }
    }
}

