/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.io.InputStream;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.rap.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.rap.rwt.internal.util.StreamUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.graphics.InternalImage;
import org.eclipse.swt.internal.graphics.InternalImageFactory;

public class ImageFactory {
    private final SharedInstanceBuffer<String, Image> cache = new SharedInstanceBuffer();

    public static String getImagePath(Image image) {
        String result = null;
        if (image != null) {
            InternalImage internalImage = image.internalImage;
            String resourceName = internalImage.getResourceName();
            result = internalImage.isExternal() ? resourceName : RWT.getResourceManager().getLocation(resourceName);
        }
        return result;
    }

    public Image findImage(String path) {
        return this.findImage(path, ImageFactory.class.getClassLoader());
    }

    public Image findImage(String path, final ClassLoader imageLoader) {
        return this.cache.get(path, new SharedInstanceBuffer.InstanceCreator<String, Image>(){

            @Override
            public Image createInstance(String path) {
                return ImageFactory.this.createImage(path, imageLoader);
            }
        });
    }

    public Image findImage(String path, final InputStream inputStream) {
        return this.cache.get(path, new SharedInstanceBuffer.InstanceCreator<String, Image>(){

            @Override
            public Image createInstance(String path) {
                return ImageFactory.this.createImage(null, path, inputStream);
            }
        });
    }

    private Image createImage(String path, ClassLoader imageLoader) {
        Image result;
        InputStream inputStream = imageLoader.getResourceAsStream(path);
        try {
            result = this.createImage(null, path, inputStream);
        }
        finally {
            if (inputStream != null) {
                StreamUtil.close(inputStream);
            }
        }
        return result;
    }

    public Image createImage(Device device, String key, InputStream inputStream) {
        InternalImageFactory internalImageFactory = ContextProvider.getApplicationContext().getInternalImageFactory();
        InternalImage internalImage = internalImageFactory.findInternalImage(key, inputStream);
        return ImageFactory.createImageInstance(device, internalImage);
    }

    static Image createImageInstance(Device device, InternalImage internalImage) {
        Class[] paramTypes = new Class[]{Device.class, InternalImage.class};
        Object[] paramValues = new Object[]{device, internalImage};
        return ClassUtil.newInstance(Image.class, paramTypes, paramValues);
    }
}

