/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import java.util.ArrayList;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.pages.internal.ImageUtil;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class CanvasExamplePage
implements IExamplePage {
    private static final int MODE_INIT = 0;
    private static final int MODE_POLYFORM = 1;
    private static final int MODE_OVAL = 2;
    private static final int MODE_CURVE = 3;
    private static final int MODE_STAMP = 4;
    private static final int SNAP_DISTANCE = 6;
    private static final int LINE_WIDTH = 1;
    private static final RGB[] COLORS = new RGB[]{new RGB(21, 184, 185), new RGB(102, 169, 58), new RGB(71, 110, 188), new RGB(251, 113, 189), new RGB(144, 202, 215), new RGB(254, 207, 21), new RGB(255, 83, 22), new RGB(182, 199, 66), new RGB(254, 159, 169), new RGB(159, 122, 171), new RGB(66, 187, 134)};
    private static final String ICON_POLYFORM = "polyform.png";
    private static final String ICON_OVAL = "oval.png";
    private static final String ICON_CURVE = "curve.png";
    private static final String ICON_STAMP = "stamp.png";
    private static final String ICON_TRANSPARENCY = "transparency.png";
    private static final String ICON_CLEAR = "clear.png";
    private Canvas drawingArea;
    private int mode;
    private ArrayList<Object[]> path = new ArrayList();
    private int[] currentParam;
    private Point currentStart;
    private int currentColor;
    private Image stampImage;
    private int currentAlpha = 128;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)ExampleUtil.createFillData());
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)false, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)composite, (String)"click to draw shapes", (int)2);
        this.createControlToolBar(composite);
        this.createDrawingArea(composite);
        this.createStampImage(parent.getDisplay());
        parent.layout();
        this.init();
    }

    private void createControlToolBar(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 512);
        toolBar.setLayoutData((Object)new GridData(1, 128, false, true));
        this.createPolyformButton(toolBar).setSelection(true);
        this.createOvalButton(toolBar);
        this.createCurveButton(toolBar);
        this.createStampButton(toolBar);
        this.createSeparator(toolBar);
        this.createTransparencyButton(toolBar).setSelection(true);
        this.createSeparator(toolBar);
        this.createClearButton(toolBar);
    }

    private ToolItem createPolyformButton(ToolBar toolBar) {
        ToolItem button = CanvasExamplePage.createToolButton(toolBar, 16, ICON_POLYFORM, "Polyform");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((ToolItem)event.widget).getSelection()) {
                    CanvasExamplePage.this.setMode(1);
                }
            }
        });
        return button;
    }

    private void createOvalButton(ToolBar toolBar) {
        ToolItem button = CanvasExamplePage.createToolButton(toolBar, 16, ICON_OVAL, "Oval");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((ToolItem)event.widget).getSelection()) {
                    CanvasExamplePage.this.setMode(2);
                }
            }
        });
    }

    private void createCurveButton(ToolBar toolBar) {
        ToolItem button = CanvasExamplePage.createToolButton(toolBar, 16, ICON_CURVE, "Curved Line");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((ToolItem)event.widget).getSelection()) {
                    CanvasExamplePage.this.setMode(3);
                }
            }
        });
    }

    private void createStampButton(ToolBar toolBar) {
        ToolItem button = CanvasExamplePage.createToolButton(toolBar, 16, ICON_STAMP, "Stamp");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((ToolItem)event.widget).getSelection()) {
                    CanvasExamplePage.this.setMode(4);
                }
            }
        });
    }

    private ToolItem createTransparencyButton(ToolBar toolBar) {
        ToolItem button = CanvasExamplePage.createToolButton(toolBar, 32, ICON_TRANSPARENCY, "Transparency");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean selected = ((ToolItem)event.widget).getSelection();
                CanvasExamplePage.this.currentAlpha = selected ? 128 : 255;
            }
        });
        return button;
    }

    private void createClearButton(ToolBar toolBar) {
        ToolItem toolButton = CanvasExamplePage.createToolButton(toolBar, 8, ICON_CLEAR, "Clear");
        toolButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CanvasExamplePage.this.clear();
            }
        });
    }

    private static ToolItem createToolButton(ToolBar parent, int style, String icon, String tooltip) {
        ToolItem toolButton = new ToolItem(parent, style);
        toolButton.setImage(ImageUtil.getImage((Device)parent.getDisplay(), icon));
        toolButton.setToolTipText(tooltip);
        return toolButton;
    }

    private void createSeparator(ToolBar toolBar) {
        new ToolItem(toolBar, 2);
    }

    private void createDrawingArea(Composite parent) {
        this.drawingArea = new Canvas(parent, 2048);
        this.drawingArea.setLayoutData((Object)ExampleUtil.createFillData());
        this.drawingArea.setBackground(parent.getDisplay().getSystemColor(1));
        this.drawingArea.setCursor(parent.getDisplay().getSystemCursor(2));
        this.drawingArea.addPaintListener((PaintListener)new DrawingAreaPaintListener());
        this.drawingArea.addMouseListener((MouseListener)new DrawingAreaMouseListener());
    }

    private void createStampImage(Display display) {
        this.stampImage = ImageUtil.getImage((Device)this.drawingArea.getDisplay(), "rap.png");
    }

    private void setMode(int mode) {
        this.newOperation();
        this.mode = mode;
    }

    private void addToCurrentParam(int x, int y) {
        if (this.currentParam == null) {
            this.currentParam = new int[]{x, y};
            this.currentStart = new Point(x, y);
        } else {
            int length = this.currentParam.length;
            int[] newParam = new int[length + 2];
            System.arraycopy(this.currentParam, 0, newParam, 0, length);
            newParam[length] = x;
            newParam[length + 1] = y;
            this.currentParam = newParam;
        }
    }

    private void addOperationToPath() {
        Object fill = this.getCurrentFill();
        switch (this.mode) {
            case 2: {
                int x0 = this.currentParam[0];
                int y0 = this.currentParam[1];
                int x1 = this.currentParam[2];
                int y1 = this.currentParam[3];
                this.currentParam = new int[]{x0, y0, x1 - x0, y1 - y0};
                break;
            }
            case 4: {
                Image stamp = (Image)fill;
                this.currentParam[0] = this.currentParam[0] - stamp.getBounds().width / 2;
                this.currentParam[1] = this.currentParam[1] - stamp.getBounds().height / 2;
            }
        }
        Object[] arg = new Object[]{new Integer(this.mode), this.currentParam, fill, new Integer(this.currentAlpha)};
        this.path.add(arg);
    }

    private Object getCurrentFill() {
        Image result;
        switch (this.mode) {
            case 4: {
                result = this.stampImage;
                break;
            }
            default: {
                result = new Color((Device)this.drawingArea.getDisplay(), COLORS[this.currentColor]);
                ++this.currentColor;
                if (this.currentColor < COLORS.length) break;
                this.currentColor = 0;
            }
        }
        return result;
    }

    private void clear() {
        this.path = new ArrayList();
        this.newOperation();
    }

    private void init() {
        this.path = new ArrayList();
        this.newOperation();
        this.mode = 0;
        this.addOperationToPath();
        this.newOperation();
        this.mode = 1;
    }

    private void newOperation() {
        this.currentParam = null;
        this.currentStart = null;
        this.drawingArea.redraw();
    }

    private boolean isNearStart(int x, int y) {
        boolean result = false;
        if (this.currentStart != null) {
            int diffX = Math.abs(this.currentStart.x - x);
            int diffY = Math.abs(this.currentStart.y - y);
            result = diffX < 6 && diffY < 6;
        }
        return result;
    }

    private void drawStartPoint(GC gc) {
        int x = this.currentStart.x - 6;
        int y = this.currentStart.y - 6;
        int diameter = 12;
        gc.setForeground(gc.getDevice().getSystemColor(2));
        gc.setBackground(gc.getDevice().getSystemColor(1));
        gc.setLineWidth(1);
        gc.fillOval(x, y, diameter, diameter);
        gc.drawOval(x, y, diameter, diameter);
    }

    public static Path createCurvedPath(Device device, int[] param) {
        Path path = new Path(device);
        if (param.length >= 2) {
            path.moveTo((float)param[0], (float)param[1]);
            int i = 2;
            while (i < param.length) {
                int cx = param[i - 2];
                int cy = param[i - 1];
                int x = (param[i] + param[i - 2]) / 2;
                int y = (param[i + 1] + param[i - 1]) / 2;
                path.quadTo((float)cx, (float)cy, (float)x, (float)y);
                i += 2;
            }
            path.lineTo((float)param[param.length - 2], (float)param[param.length - 1]);
        }
        return path;
    }

    private final class DrawingAreaMouseListener
    extends MouseAdapter {
        private DrawingAreaMouseListener() {
        }

        public void mouseDown(MouseEvent e) {
            switch (CanvasExamplePage.this.mode) {
                case 1: {
                    if (CanvasExamplePage.this.isNearStart(e.x, e.y)) {
                        CanvasExamplePage.this.addOperationToPath();
                        CanvasExamplePage.this.newOperation();
                        break;
                    }
                    CanvasExamplePage.this.addToCurrentParam(e.x, e.y);
                    break;
                }
                case 2: {
                    CanvasExamplePage.this.addToCurrentParam(e.x, e.y);
                    if (CanvasExamplePage.this.currentParam.length != 4) break;
                    CanvasExamplePage.this.addOperationToPath();
                    CanvasExamplePage.this.newOperation();
                    break;
                }
                case 3: {
                    CanvasExamplePage.this.addToCurrentParam(e.x, e.y);
                    if (CanvasExamplePage.this.currentParam.length != 8) break;
                    CanvasExamplePage.this.addOperationToPath();
                    CanvasExamplePage.this.newOperation();
                    break;
                }
                case 4: {
                    CanvasExamplePage.this.addToCurrentParam(e.x, e.y);
                    CanvasExamplePage.this.addOperationToPath();
                    CanvasExamplePage.this.newOperation();
                }
            }
            CanvasExamplePage.this.drawingArea.redraw();
        }
    }

    private final class DrawingAreaPaintListener
    implements PaintListener {
        private DrawingAreaPaintListener() {
        }

        public void paintControl(PaintEvent event) {
            GC gc = event.gc;
            int i = 0;
            while (i < CanvasExamplePage.this.path.size()) {
                Object[] operation = (Object[])CanvasExamplePage.this.path.get(i);
                int operationMode = (Integer)operation[0];
                int[] param = (int[])operation[1];
                gc.setForeground(gc.getDevice().getSystemColor(2));
                gc.setLineWidth(1);
                gc.setAlpha(((Integer)operation[3]).intValue());
                switch (operationMode) {
                    case 0: {
                        gc.setBackground(new Color((Device)CanvasExamplePage.this.drawingArea.getDisplay(), COLORS[4]));
                        gc.fillOval(100, 50, 350, 350);
                        gc.setBackground(new Color((Device)CanvasExamplePage.this.drawingArea.getDisplay(), COLORS[5]));
                        gc.fillOval(300, 150, 400, 300);
                        gc.setBackground(new Color((Device)CanvasExamplePage.this.drawingArea.getDisplay(), COLORS[6]));
                        gc.fillOval(500, 100, 250, 300);
                        break;
                    }
                    case 1: {
                        gc.setBackground((Color)operation[2]);
                        gc.fillPolygon(param);
                        break;
                    }
                    case 2: {
                        gc.setBackground((Color)operation[2]);
                        gc.fillOval(param[0], param[1], param[2], param[3]);
                        break;
                    }
                    case 3: {
                        gc.setForeground((Color)operation[2]);
                        gc.setLineWidth(3);
                        gc.setAlpha(255);
                        gc.drawPath(CanvasExamplePage.createCurvedPath((Device)CanvasExamplePage.this.drawingArea.getDisplay(), param));
                        break;
                    }
                    case 4: {
                        gc.drawImage((Image)operation[2], param[0], param[1]);
                    }
                }
                ++i;
            }
            if (CanvasExamplePage.this.currentParam != null) {
                gc.setAlpha(255);
                CanvasExamplePage.this.drawStartPoint(gc);
                switch (CanvasExamplePage.this.mode) {
                    case 1: {
                        gc.drawPolyline(CanvasExamplePage.this.currentParam);
                        break;
                    }
                    case 3: {
                        gc.setForeground(gc.getDevice().getSystemColor(2));
                        gc.setLineWidth(1);
                        gc.drawPath(CanvasExamplePage.createCurvedPath(gc.getDevice(), CanvasExamplePage.this.currentParam));
                    }
                }
            }
        }
    }
}

