/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ClipboardTab
extends ExampleTab {
    private Clipboard clipboard;
    private Text copyText;
    private Text pasteText;

    public ClipboardTab() {
        super("Clipboard");
        int[] nArray = new int[2];
        nArray[0] = 100;
        this.setHorizontalSashFormWeights(nArray);
    }

    @Override
    protected void createStyleControls(Composite parent) {
    }

    @Override
    protected void createExampleControls(Composite parent) {
        this.clipboard = new Clipboard(parent.getDisplay());
        this.configureDisplay(parent.getDisplay());
        parent.setLayout((Layout)new GridLayout(2, false));
        this.copyText = new Text(parent, 2052);
        this.copyText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button copyButton = new Button(parent, 8);
        copyButton.setText("Copy");
        copyButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String text = ClipboardTab.this.copyText.getText();
                if (!text.isEmpty()) {
                    ClipboardTab.this.setClipboardData(text);
                }
            }
        });
        this.pasteText = new Text(parent, 2052);
        this.pasteText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button pasteButton = new Button(parent, 8);
        pasteButton.setText("Paste");
        pasteButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String text = ClipboardTab.this.getClipboardData();
                ClipboardTab.this.pasteText.setText(text);
            }
        });
    }

    private void configureDisplay(Display display) {
        display.setData("org.eclipse.rap.rwt.activeKeys", (Object)new String[]{"CTRL+C", "CTRL+V"});
        display.setData("org.eclipse.rap.rwt.cancelKeys", (Object)new String[]{"CTRL+C", "CTRL+V"});
        display.addFilter(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == 'c') {
                    String text = ClipboardTab.this.copyText.getText();
                    if (!text.isEmpty()) {
                        ClipboardTab.this.setClipboardData(text);
                    }
                } else if (event.character == 'v') {
                    String text = ClipboardTab.this.getClipboardData();
                    ClipboardTab.this.pasteText.setText(text);
                }
            }
        });
    }

    private void setClipboardData(String textData) {
        try {
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
            Object[] data = new Object[]{textData};
            this.clipboard.setContents(data, transfers);
        }
        catch (SWTError sWTError) {
            String message = "Unable to set client clipboard data!";
            MessageDialog.openError((Shell)this.getShell(), (String)"Clipboard Error", (String)message);
        }
    }

    private String getClipboardData() {
        String textData = (String)this.clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (textData == null) {
            String message = "Unable to get client clipboard data!";
            MessageDialog.openError((Shell)this.getShell(), (String)"Clipboard Error", (String)message);
            return "";
        }
        return textData;
    }
}

