/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.rap.rwt.internal.util.SharedInstanceBuffer;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.internal.SerializableCompatibility;

public class SingletonManager
implements SerializableCompatibility {
    private static final String ATTR_SINGLETON_MANAGER = String.valueOf(SingletonManager.class.getName()) + "#instance";
    private final SharedInstanceBuffer<Class<?>, AtomicReference<Object>> singletonHolders = new SharedInstanceBuffer();
    private SharedInstanceBuffer.InstanceCreator<Class<?>, AtomicReference<Object>> instanceCreator = new SharedInstanceBuffer.InstanceCreator<Class<?>, AtomicReference<Object>>(){

        @Override
        public AtomicReference<Object> createInstance(Class<?> key) {
            return new AtomicReference<Object>();
        }
    };

    SingletonManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getSingleton(Class<T> type) {
        AtomicReference<T> singletonHolder;
        AtomicReference<T> atomicReference = singletonHolder = this.getSingletonHolder(type);
        synchronized (atomicReference) {
            T singleton = singletonHolder.get();
            if (singleton == null) {
                singleton = ClassUtil.newInstance(type);
                singletonHolder.set(singleton);
            }
            return singleton;
        }
    }

    private <T> AtomicReference<T> getSingletonHolder(Class<T> type) {
        AtomicReference<Object> result = this.singletonHolders.get(type, this.instanceCreator);
        return result;
    }

    public static void install(UISession uiSession) {
        SingletonManager.checkNotInstalled(uiSession);
        uiSession.setAttribute(ATTR_SINGLETON_MANAGER, new SingletonManager());
    }

    public static void install(ApplicationContext applicationContext) {
        SingletonManager.checkNotInstalled(applicationContext);
        applicationContext.setAttribute(ATTR_SINGLETON_MANAGER, new SingletonManager());
    }

    public static SingletonManager getInstance(UISession uiSession) {
        return (SingletonManager)uiSession.getAttribute(ATTR_SINGLETON_MANAGER);
    }

    public static SingletonManager getInstance(ApplicationContext applicationContext) {
        return (SingletonManager)applicationContext.getAttribute(ATTR_SINGLETON_MANAGER);
    }

    private static void checkNotInstalled(UISession uiSession) {
        if (SingletonManager.getInstance(uiSession) != null) {
            String msg = "SingletonManager already installed for UI session: " + uiSession.getId();
            throw new IllegalStateException(msg);
        }
    }

    private static void checkNotInstalled(ApplicationContext applicationContext) {
        if (SingletonManager.getInstance(applicationContext) != null) {
            String msg = "SingletonManager already installed for application context";
            throw new IllegalStateException(msg);
        }
    }
}

