/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.remote;

import java.lang.reflect.Field;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.widgets.Widget;

public class JsonMapping {
    private static final String CURSOR_UPARROW = "rwt-resources/resource/widget/rap/cursors/up_arrow.cur";

    private JsonMapping() {
    }

    public static JsonValue toJson(Widget widget) {
        if (widget == null) {
            return JsonValue.NULL;
        }
        if (widget.isDisposed()) {
            throw new IllegalArgumentException("Widget is disposed");
        }
        return JsonValue.valueOf(WidgetUtil.getId(widget));
    }

    public static JsonValue toJson(Widget[] widgets) {
        JsonArray widgetIds = new JsonArray();
        Widget[] widgetArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            widgetIds.add(JsonMapping.toJson(widget));
            ++n2;
        }
        return widgetIds;
    }

    public static JsonValue toJson(Point point) {
        return point == null ? JsonValue.NULL : new JsonArray().add(point.x).add(point.y);
    }

    public static JsonValue toJson(Rectangle rect) {
        if (rect == null) {
            return JsonValue.NULL;
        }
        return new JsonArray().add(rect.x).add(rect.y).add(rect.width).add(rect.height);
    }

    public static JsonValue toJson(Color color) {
        return JsonMapping.toJson(color, 255);
    }

    public static JsonValue toJson(Color color, int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Illegal alpha value: " + alpha);
        }
        if (color == null) {
            return JsonValue.NULL;
        }
        if (color.isDisposed()) {
            throw new IllegalArgumentException("Color is disposed");
        }
        return JsonMapping.toJson(color.getRGB(), alpha);
    }

    public static JsonValue toJson(RGB rgb) {
        return JsonMapping.toJson(rgb, 255);
    }

    public static JsonValue toJson(RGB rgb, int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Illegal alpha value: " + alpha);
        }
        if (rgb == null) {
            return JsonValue.NULL;
        }
        return new JsonArray().add(rgb.red).add(rgb.green).add(rgb.blue).add(alpha);
    }

    public static JsonValue toJson(Image image) {
        if (image == null) {
            return JsonValue.NULL;
        }
        if (image.isDisposed()) {
            throw new IllegalArgumentException("Image is disposed");
        }
        String imagePath = ImageFactory.getImagePath(image);
        Rectangle bounds = image.getBounds();
        return new JsonArray().add(imagePath).add(bounds.width).add(bounds.height);
    }

    public static JsonValue toJson(Font font) {
        if (font == null) {
            return JsonValue.NULL;
        }
        if (font.isDisposed()) {
            throw new IllegalArgumentException("Font is disposed");
        }
        return JsonMapping.toJson(FontUtil.getData(font));
    }

    public static JsonValue toJson(FontData fontData) {
        return fontData == null ? JsonValue.NULL : new JsonArray().add(JsonUtil.createJsonArray(ProtocolUtil.parseFontName(fontData.getName()))).add(fontData.getHeight()).add((fontData.getStyle() & 1) != 0).add((fontData.getStyle() & 2) != 0);
    }

    public static JsonValue toJson(Cursor cursor) {
        if (cursor == null) {
            return JsonValue.NULL;
        }
        int value = 0;
        try {
            Field field = Cursor.class.getDeclaredField("value");
            field.setAccessible(true);
            value = field.getInt(cursor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        switch (value) {
            case 0: {
                return JsonValue.valueOf("default");
            }
            case 1: {
                return JsonValue.valueOf("wait");
            }
            case 3: {
                return JsonValue.valueOf("progress");
            }
            case 2: {
                return JsonValue.valueOf("crosshair");
            }
            case 4: {
                return JsonValue.valueOf("help");
            }
            case 5: {
                return JsonValue.valueOf("move");
            }
            case 7: {
                return JsonValue.valueOf("row-resize");
            }
            case 9: {
                return JsonValue.valueOf("col-resize");
            }
            case 10: {
                return JsonValue.valueOf("n-resize");
            }
            case 11: {
                return JsonValue.valueOf("s-resize");
            }
            case 12: {
                return JsonValue.valueOf("e-resize");
            }
            case 13: {
                return JsonValue.valueOf("w-resize");
            }
            case 6: 
            case 14: {
                return JsonValue.valueOf("ne-resize");
            }
            case 15: {
                return JsonValue.valueOf("se-resize");
            }
            case 16: {
                return JsonValue.valueOf("sw-resize");
            }
            case 8: 
            case 17: {
                return JsonValue.valueOf("nw-resize");
            }
            case 19: {
                return JsonValue.valueOf("text");
            }
            case 21: {
                return JsonValue.valueOf("pointer");
            }
            case 20: {
                return JsonValue.valueOf("not-allowed");
            }
            case 18: {
                return JsonValue.valueOf(CURSOR_UPARROW);
            }
        }
        return JsonValue.NULL;
    }

    public static Point readPoint(JsonValue value) {
        ParamCheck.notNull(value, "value");
        if (JsonValue.NULL.equals(value)) {
            return null;
        }
        try {
            JsonArray array = value.asArray();
            if (array.size() != 2) {
                throw new IllegalArgumentException("array size != 2");
            }
            return new Point(array.get(0).asInt(), array.get(1).asInt());
        }
        catch (Exception exception) {
            String message = "Could not create Point for: " + value;
            throw new IllegalArgumentException(message, exception);
        }
    }

    public static Rectangle readRectangle(JsonValue value) {
        ParamCheck.notNull(value, "value");
        if (JsonValue.NULL.equals(value)) {
            return null;
        }
        try {
            JsonArray array = value.asArray();
            if (array.size() != 4) {
                throw new IllegalArgumentException("array size != 4");
            }
            return new Rectangle(array.get(0).asInt(), array.get(1).asInt(), array.get(2).asInt(), array.get(3).asInt());
        }
        catch (Exception exception) {
            String message = "Could not create Rectangle for: " + value;
            throw new IllegalArgumentException(message, exception);
        }
    }

    public static RGB readRGB(JsonValue value) {
        ParamCheck.notNull(value, "value");
        if (value.isNull()) {
            return null;
        }
        try {
            JsonArray array = value.asArray();
            if (array.size() < 3 || array.size() > 4) {
                throw new IllegalArgumentException("Expected array of size 3 or 4");
            }
            return new RGB(array.get(0).asInt(), array.get(1).asInt(), array.get(2).asInt());
        }
        catch (Exception exception) {
            String message = "Could not create RGB for: " + value;
            throw new IllegalArgumentException(message, exception);
        }
    }
}

