/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetDataUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.StylesUtil;
import org.eclipse.rap.rwt.internal.scripting.ClientListenerOperation;
import org.eclipse.rap.rwt.internal.scripting.ClientListenerUtil;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.WidgetRemoteAdapter;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public final class WidgetLCAUtil {
    private static final String PROP_TOOLTIP = "toolTip";
    private static final String PROP_TOOLTIP_MARKUP_ENABLED = "toolTipMarkupEnabled";
    private static final String PROP_FONT = "font";
    private static final String PROP_FOREGROUND = "foreground";
    private static final String PROP_BACKGROUND = "background";
    private static final String PROP_BACKGROUND_TRANSPARENCY = "backgroundTrans";
    private static final String PROP_BACKGROUND_GRADIENT_COLORS = "backgroundGradientColors";
    private static final String PROP_BACKGROUND_GRADIENT_PERCENTS = "backgroundGradientPercents";
    private static final String PROP_BACKGROUND_GRADIENT_VERTICAL = "backgroundGradientVertical";
    private static final String PROP_ROUNDED_BORDER_WIDTH = "roundedBorderWidth";
    private static final String PROP_ROUNDED_BORDER_COLOR = "roundedBorderColor";
    private static final String PROP_ROUNDED_BORDER_RADIUS = "roundedBorderRadius";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_DATA = "data";
    private static final String PROP_VARIANT = "customVariant";
    private static final String PROP_HELP_LISTENER = "Help";
    private static final String PROP_SELECTION_LISTENER = "Selection";
    private static final String PROP_DEFAULT_SELECTION_LISTENER = "DefaultSelection";
    private static final String PROP_MODIFY_LISTENER = "Modify";
    private static final String PROP_KEY_LISTENER = "KeyDown";
    private static final Rectangle DEF_ROUNDED_BORDER_RADIUS = new Rectangle(0, 0, 0, 0);

    private WidgetLCAUtil() {
    }

    public static void preserveBounds(Widget widget, Rectangle bounds) {
        WidgetUtil.getAdapter(widget).preserve("bounds", bounds);
    }

    public static void preserveEnabled(Widget widget, boolean enabled) {
        WidgetUtil.getAdapter(widget).preserve(PROP_ENABLED, enabled);
    }

    public static void preserveToolTipText(Widget widget, String toolTip) {
        String text = toolTip == null ? "" : toolTip;
        WidgetUtil.getAdapter(widget).preserve(PROP_TOOLTIP, text);
    }

    public static void preserveFont(Widget widget, Font font) {
        WidgetUtil.getAdapter(widget).preserve(PROP_FONT, font);
    }

    public static void preserveForeground(Widget widget, Color foreground) {
        WidgetUtil.getAdapter(widget).preserve(PROP_FOREGROUND, foreground);
    }

    public static void preserveBackground(Widget widget, Color background) {
        WidgetLCAUtil.preserveBackground(widget, background, false);
    }

    public static void preserveBackground(Widget widget, Color background, boolean transparency) {
        RemoteAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_BACKGROUND, background);
        adapter.preserve(PROP_BACKGROUND_TRANSPARENCY, transparency);
    }

    public static void preserveBackgroundGradient(Widget widget) {
        IWidgetGraphicsAdapter adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        if (adapter != null) {
            IWidgetGraphicsAdapter gfxAdapter = adapter;
            Color[] bgGradientColors = gfxAdapter.getBackgroundGradientColors();
            int[] bgGradientPercents = gfxAdapter.getBackgroundGradientPercents();
            boolean bgGradientVertical = gfxAdapter.isBackgroundGradientVertical();
            RemoteAdapter widgetAdapter = WidgetUtil.getAdapter(widget);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_COLORS, bgGradientColors);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_PERCENTS, bgGradientPercents);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_VERTICAL, bgGradientVertical);
        }
    }

    public static void preserveRoundedBorder(Widget widget) {
        IWidgetGraphicsAdapter adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        if (adapter != null) {
            IWidgetGraphicsAdapter gfxAdapter = adapter;
            int width = gfxAdapter.getRoundedBorderWidth();
            Color color = gfxAdapter.getRoundedBorderColor();
            Rectangle radius = gfxAdapter.getRoundedBorderRadius();
            RemoteAdapter widgetAdapter = WidgetUtil.getAdapter(widget);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_WIDTH, width);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_COLOR, color);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_RADIUS, radius);
        }
    }

    public static void preserveData(Widget widget) {
        WidgetRemoteAdapter remoteAdapter = WidgetLCAUtil.getRemoteAdapter(widget);
        if (!remoteAdapter.hasPreservedData()) {
            remoteAdapter.preserveData(WidgetLCAUtil.getData(widget));
        }
    }

    public static void renderData(Widget widget) {
        Object[] preserved;
        Object[] actual;
        WidgetRemoteAdapter remoteAdapter = WidgetLCAUtil.getRemoteAdapter(widget);
        if (remoteAdapter.hasPreservedData() && WidgetLCAUtil.changed(widget, actual = WidgetLCAUtil.getData(widget), preserved = remoteAdapter.getPreservedData(), null)) {
            RemoteObjectFactory.getRemoteObject(widget).set(PROP_DATA, WidgetLCAUtil.getJsonForData(actual));
        }
    }

    public static void preserveCustomVariant(Widget widget) {
        WidgetRemoteAdapter remoteAdapter = WidgetLCAUtil.getRemoteAdapter(widget);
        if (!remoteAdapter.hasPreservedVariant()) {
            remoteAdapter.preserveVariant(WidgetUtil.getVariant(widget));
        }
    }

    public static void renderCustomVariant(Widget widget) {
        String preserved;
        String actual;
        WidgetRemoteAdapter remoteAdapter = WidgetLCAUtil.getRemoteAdapter(widget);
        if (remoteAdapter.hasPreservedVariant() && WidgetLCAUtil.changed(widget, actual = WidgetUtil.getVariant(widget), preserved = remoteAdapter.getPreservedVariant(), null)) {
            RemoteObjectFactory.getRemoteObject(widget).set(PROP_VARIANT, actual == null ? null : "variant_" + actual);
        }
    }

    public static void renderBounds(Widget widget, Rectangle bounds) {
        WidgetLCAUtil.renderProperty(widget, "bounds", bounds, null);
    }

    public static void renderEnabled(Widget widget, boolean enabled) {
        WidgetLCAUtil.renderProperty(widget, PROP_ENABLED, enabled, true);
    }

    public static void renderMenu(Widget widget, Menu menu) {
        WidgetLCAUtil.renderProperty(widget, "menu", menu, null);
    }

    public static void renderToolTip(Widget widget, String toolTip) {
        String text;
        WidgetLCAUtil.renderToolTipMarkupEnabled(widget);
        String string = text = toolTip == null ? "" : toolTip;
        if (WidgetLCAUtil.hasChanged(widget, PROP_TOOLTIP, text, "")) {
            if (!MarkupUtil.isToolTipMarkupEnabledFor(widget)) {
                text = MnemonicUtil.removeAmpersandControlCharacters(text);
            }
            RemoteObjectFactory.getRemoteObject(widget).set(PROP_TOOLTIP, text);
        }
    }

    static void renderToolTipMarkupEnabled(Widget widget) {
        RemoteAdapter adapter = WidgetUtil.getAdapter(widget);
        if (!adapter.isInitialized() && MarkupUtil.isToolTipMarkupEnabledFor(widget)) {
            RemoteObjectFactory.getRemoteObject(widget).set(PROP_TOOLTIP_MARKUP_ENABLED, true);
        }
    }

    public static void renderFont(Widget widget, Font font) {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FONT, font, null)) {
            RemoteObjectFactory.getRemoteObject(widget).set(PROP_FONT, JsonMapping.toJson(font));
        }
    }

    public static void renderForeground(Widget widget, Color newColor) {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FOREGROUND, newColor, null)) {
            RemoteObjectFactory.getRemoteObject(widget).set(PROP_FOREGROUND, JsonMapping.toJson(newColor));
        }
    }

    public static void renderBackground(Widget widget, Color newColor) {
        WidgetLCAUtil.renderBackground(widget, newColor, false);
    }

    public static void renderBackground(Widget widget, Color background, boolean transparency) {
        boolean transparencyChanged = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_TRANSPARENCY, transparency, Boolean.FALSE);
        boolean colorChanged = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND, background, null);
        if (transparencyChanged || colorChanged) {
            JsonValue color = transparency && background == null ? JsonMapping.toJson(new RGB(0, 0, 0), 0) : JsonMapping.toJson(background, transparency ? 0 : 255);
            RemoteObjectFactory.getRemoteObject(widget).set(PROP_BACKGROUND, color);
        }
    }

    public static void renderBackgroundGradient(Widget widget) {
        if (WidgetLCAUtil.hasBackgroundGradientChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicsAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
            JsonValue args = JsonValue.NULL;
            if (bgGradientColors != null) {
                JsonArray colors = new JsonArray();
                int i = 0;
                while (i < bgGradientColors.length) {
                    colors.add(JsonMapping.toJson(bgGradientColors[i]));
                    ++i;
                }
                int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
                JsonArray percents = JsonUtil.createJsonArray(bgGradientPercents);
                boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
                args = new JsonArray().add(colors).add(percents).add(bgGradientVertical);
            }
            RemoteObjectFactory.getRemoteObject(widget).set("backgroundGradient", args);
        }
    }

    private static boolean hasBackgroundGradientChanged(Widget widget) {
        IWidgetGraphicsAdapter graphicsAdapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
        int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
        boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
        return WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_COLORS, bgGradientColors, null) || WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_PERCENTS, bgGradientPercents, null) || WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_VERTICAL, bgGradientVertical, Boolean.FALSE);
    }

    public static void renderRoundedBorder(Widget widget) {
        if (WidgetLCAUtil.hasRoundedBorderChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            JsonValue args = JsonValue.NULL;
            int width = graphicAdapter.getRoundedBorderWidth();
            Color color = graphicAdapter.getRoundedBorderColor();
            if (width > 0 && color != null) {
                Rectangle radius = graphicAdapter.getRoundedBorderRadius();
                args = new JsonArray().add(width).add(JsonMapping.toJson(color)).add(radius.x).add(radius.y).add(radius.width).add(radius.height);
            }
            RemoteObjectFactory.getRemoteObject(widget).set("roundedBorder", args);
        }
    }

    private static boolean hasRoundedBorderChanged(Widget widget) {
        IWidgetGraphicsAdapter adapter;
        IWidgetGraphicsAdapter graphicsAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        int width = graphicsAdapter.getRoundedBorderWidth();
        Color color = graphicsAdapter.getRoundedBorderColor();
        Rectangle radius = graphicsAdapter.getRoundedBorderRadius();
        return WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_WIDTH, width, 0) || WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_COLOR, color, null) || WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_RADIUS, radius, DEF_ROUNDED_BORDER_RADIUS);
    }

    public static boolean wasEventSent(Widget widget, String eventName) {
        return ProtocolUtil.wasEventSent(WidgetUtil.getId(widget), eventName);
    }

    public static void preserveProperty(Widget widget, String property, Object value) {
        WidgetUtil.getAdapter(widget).preserve(property, value);
    }

    public static void preserveProperty(Widget widget, String property, int value) {
        WidgetLCAUtil.preserveProperty(widget, property, (Object)value);
    }

    public static void preserveProperty(Widget widget, String property, boolean value) {
        WidgetLCAUtil.preserveProperty(widget, property, (Object)value);
    }

    public static void renderProperty(Widget widget, String property, String newValue, String defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            RemoteObjectFactory.getRemoteObject(widget).set(property, newValue);
        }
    }

    public static void renderProperty(Widget widget, String property, Integer newValue, Integer defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            JsonValue value = newValue == null ? JsonValue.NULL : JsonValue.valueOf(newValue);
            RemoteObjectFactory.getRemoteObject(widget).set(property, value);
        }
    }

    public static void renderProperty(Widget widget, String property, String[] newValue, String[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            JsonValue value = newValue == null ? JsonValue.NULL : JsonUtil.createJsonArray(newValue);
            RemoteObjectFactory.getRemoteObject(widget).set(property, value);
        }
    }

    public static void renderProperty(Widget widget, String property, boolean[] newValue, boolean[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            JsonValue value = newValue == null ? JsonValue.NULL : JsonUtil.createJsonArray(newValue);
            RemoteObjectFactory.getRemoteObject(widget).set(property, value);
        }
    }

    public static void renderProperty(Widget widget, String property, int[] newValue, int[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            JsonValue value = newValue == null ? JsonValue.NULL : JsonUtil.createJsonArray(newValue);
            RemoteObjectFactory.getRemoteObject(widget).set(property, value);
        }
    }

    public static void renderProperty(Widget widget, String property, int newValue, int defaultValue) {
        Integer defaultValueObject;
        Integer newValueObject = newValue;
        if (WidgetLCAUtil.hasChanged(widget, property, newValueObject, defaultValueObject = Integer.valueOf(defaultValue))) {
            RemoteObjectFactory.getRemoteObject(widget).set(property, newValue);
        }
    }

    public static void renderProperty(Widget widget, String property, boolean newValue, boolean defaultValue) {
        Boolean defaultValueObject;
        Boolean newValueObject = newValue;
        if (WidgetLCAUtil.hasChanged(widget, property, newValueObject, defaultValueObject = Boolean.valueOf(defaultValue))) {
            RemoteObjectFactory.getRemoteObject(widget).set(property, newValue);
        }
    }

    public static void renderProperty(Widget widget, String property, Image newValue, Image defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            RemoteObjectFactory.getRemoteObject(widget).set(property, JsonMapping.toJson(newValue));
        }
    }

    public static void renderProperty(Widget widget, String property, Image[] newValue, Image[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            JsonValue value = newValue == null ? JsonValue.NULL : JsonUtil.createJsonArray(newValue);
            RemoteObjectFactory.getRemoteObject(widget).set(property, value);
        }
    }

    public static void renderProperty(Widget widget, String property, Color newValue, Color defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            RemoteObjectFactory.getRemoteObject(widget).set(property, JsonMapping.toJson(newValue));
        }
    }

    public static void renderProperty(Widget widget, String property, Color[] newValue, Color[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            JsonValue value = newValue == null ? JsonValue.NULL : JsonUtil.createJsonArray(newValue);
            RemoteObjectFactory.getRemoteObject(widget).set(property, value);
        }
    }

    public static void renderProperty(Widget widget, String property, Font[] newValue, Font[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            JsonValue value = newValue == null ? JsonValue.NULL : JsonUtil.createJsonArray(newValue);
            RemoteObjectFactory.getRemoteObject(widget).set(property, value);
        }
    }

    public static void renderProperty(Widget widget, String property, Point newValue, Point defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            RemoteObjectFactory.getRemoteObject(widget).set(property, JsonMapping.toJson(newValue));
        }
    }

    public static void renderProperty(Widget widget, String property, Rectangle newValue, Rectangle defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            RemoteObjectFactory.getRemoteObject(widget).set(property, JsonMapping.toJson(newValue));
        }
    }

    public static void renderProperty(Widget widget, String property, Widget newValue, Widget defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            String widgetId = newValue == null ? null : WidgetUtil.getId(newValue);
            RemoteObjectFactory.getRemoteObject(widget).set(property, widgetId);
        }
    }

    public static void renderListenHelp(Widget widget) {
        WidgetLCAUtil.renderListener(widget, 28, PROP_HELP_LISTENER);
    }

    public static void renderListenSelection(Widget widget) {
        WidgetLCAUtil.renderListener(widget, 13, PROP_SELECTION_LISTENER);
    }

    public static void renderListenDefaultSelection(Widget widget) {
        WidgetLCAUtil.renderListener(widget, 14, PROP_DEFAULT_SELECTION_LISTENER);
    }

    public static void renderListenModifyVerify(Widget widget) {
        WidgetRemoteAdapter adapter = (WidgetRemoteAdapter)WidgetUtil.getAdapter(widget);
        if (adapter.hasPreservedListeners()) {
            boolean preserved;
            boolean actual = EventLCAUtil.isListening(widget, 24) || EventLCAUtil.isListening(widget, 25);
            boolean bl = preserved = EventLCAUtil.containsEvent(adapter.getPreservedListeners(), 24) || EventLCAUtil.containsEvent(adapter.getPreservedListeners(), 25);
            if (WidgetLCAUtil.changed(widget, actual, preserved, false)) {
                RemoteObjectFactory.getRemoteObject(widget).listen(PROP_MODIFY_LISTENER, actual);
            }
        }
    }

    public static void renderListenKey(Widget widget) {
        WidgetRemoteAdapter adapter = (WidgetRemoteAdapter)WidgetUtil.getAdapter(widget);
        if (adapter.hasPreservedListeners()) {
            boolean preserved;
            boolean actual = EventLCAUtil.isListening(widget, 2) || EventLCAUtil.isListening(widget, 1);
            boolean bl = preserved = EventLCAUtil.containsEvent(adapter.getPreservedListeners(), 2) || EventLCAUtil.containsEvent(adapter.getPreservedListeners(), 1);
            if (WidgetLCAUtil.changed(widget, actual, preserved, false)) {
                RemoteObjectFactory.getRemoteObject(widget).listen(PROP_KEY_LISTENER, actual);
            }
        }
    }

    public static void preserveListener(Widget widget, String listener, boolean value) {
        WidgetUtil.getAdapter(widget).preserve(listener, value);
    }

    public static void renderListener(Widget widget, String listener, boolean newValue, boolean defaultValue) {
        Boolean defaultValueObject;
        Boolean newValueObject = newValue;
        if (WidgetLCAUtil.hasChanged(widget, listener, newValueObject, defaultValueObject = Boolean.valueOf(defaultValue))) {
            RemoteObjectFactory.getRemoteObject(widget).listen(listener, newValue);
        }
    }

    public static void preserveListeners(Widget widget, long eventList) {
        WidgetRemoteAdapter adapter = (WidgetRemoteAdapter)WidgetUtil.getAdapter(widget);
        if (!adapter.hasPreservedListeners()) {
            adapter.preserveListeners(eventList);
        }
    }

    public static void renderListener(Widget widget, int eventType, String eventName) {
        WidgetLCAUtil.renderListener(widget, eventType, eventName, EventLCAUtil.isListening(widget, eventType));
    }

    private static void renderListener(Widget widget, int eventType, String eventName, boolean isListening) {
        boolean preserved;
        WidgetRemoteAdapter adapter = (WidgetRemoteAdapter)WidgetUtil.getAdapter(widget);
        if (adapter.hasPreservedListeners() && WidgetLCAUtil.changed(widget, isListening, preserved = EventLCAUtil.containsEvent(adapter.getPreservedListeners(), eventType), false)) {
            RemoteObjectFactory.getRemoteObject(widget).listen(eventName, isListening);
        }
    }

    public static void renderClientListeners(Widget widget) {
        List<ClientListenerOperation> operations = ClientListenerUtil.getClientListenerOperations(widget);
        if (operations != null) {
            for (ClientListenerOperation operation : operations) {
                JsonObject parameters = new JsonObject();
                parameters.add("listenerId", ClientListenerUtil.getRemoteId(operation.getListener()));
                parameters.add("eventType", ClientListenerUtil.getEventType(operation.getEventType()));
                if (operation instanceof ClientListenerOperation.AddListener) {
                    RemoteObjectFactory.getRemoteObject(widget).call("addListener", parameters);
                    continue;
                }
                if (!(operation instanceof ClientListenerOperation.RemoveListener)) continue;
                RemoteObjectFactory.getRemoteObject(widget).call("removeListener", parameters);
            }
        }
        ClientListenerUtil.clearClientListenerOperations(widget);
    }

    public static boolean hasChanged(Widget widget, String property, Object actualValue) {
        return !WidgetLCAUtil.equals(actualValue, WidgetUtil.getAdapter(widget).getPreserved(property));
    }

    public static boolean hasChanged(Widget widget, String property, Object actualValue, Object defaultValue) {
        Object preservedValue = WidgetUtil.getAdapter(widget).getPreserved(property);
        return WidgetLCAUtil.changed(widget, actualValue, preservedValue, defaultValue);
    }

    static boolean changed(Widget widget, Object actualValue, Object preservedValue, Object defaultValue) {
        if (WidgetUtil.getAdapter(widget).isInitialized()) {
            return !WidgetLCAUtil.equals(actualValue, preservedValue);
        }
        return !WidgetLCAUtil.equals(actualValue, defaultValue);
    }

    static boolean changed(Widget widget, boolean actualValue, boolean preservedValue, boolean defaultValue) {
        if (WidgetUtil.getAdapter(widget).isInitialized()) {
            return actualValue ^ preservedValue;
        }
        return actualValue ^ defaultValue;
    }

    static boolean changed(Widget widget, int actualValue, int preservedValue, int defaultValue) {
        if (WidgetUtil.getAdapter(widget).isInitialized()) {
            return actualValue != preservedValue;
        }
        return actualValue != defaultValue;
    }

    public static String[] getStyles(Widget widget, String[] styles) {
        return StylesUtil.filterStyles(widget, styles);
    }

    static boolean equals(Object object1, Object object2) {
        boolean result = object1 == object2 ? true : (object1 == null ? false : (object1 instanceof boolean[] && object2 instanceof boolean[] ? Arrays.equals((boolean[])object1, (boolean[])object2) : (object1 instanceof int[] && object2 instanceof int[] ? Arrays.equals((int[])object1, (int[])object2) : (object1 instanceof long[] && object2 instanceof long[] ? Arrays.equals((long[])object1, (long[])object2) : (object1 instanceof float[] && object2 instanceof float[] ? Arrays.equals((float[])object1, (float[])object2) : (object1 instanceof double[] && object2 instanceof double[] ? Arrays.equals((double[])object1, (double[])object2) : (object1 instanceof Object[] && object2 instanceof Object[] ? Arrays.equals((Object[])object1, (Object[])object2) : object1.equals(object2))))))));
        return result;
    }

    private static Object[] getData(Widget widget) {
        ArrayList<String> result = null;
        for (String key : WidgetDataUtil.getDataKeys()) {
            Object value = widget.getData(key);
            if (value == null) continue;
            if (result == null) {
                result = new ArrayList<String>();
            }
            result.add(key);
            result.add((String)value);
        }
        return result == null ? null : result.toArray();
    }

    private static JsonObject getJsonForData(Object[] data) {
        JsonObject jsonObject = new JsonObject();
        if (data != null) {
            int i = 0;
            while (i < data.length) {
                jsonObject.add((String)data[i], JsonUtil.createJsonValue(data[++i]));
                ++i;
            }
        }
        return jsonObject;
    }

    private static WidgetRemoteAdapter getRemoteAdapter(Widget widget) {
        return (WidgetRemoteAdapter)widget.getAdapter(RemoteAdapter.class);
    }
}

