/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    private final PluginTracker pluginTracker;

    public PluginManager(BundleContext context) {
        this.pluginTracker = new PluginTracker(context);
    }

    public void start() {
        this.pluginTracker.open();
    }

    public void stop() {
        this.pluginTracker.close();
    }

    public void modifyConfiguration(ServiceReference<?> managedReference, Dictionary<String, Object> properties) {
        if (properties == null) {
            return;
        }
        ServiceReference<ConfigurationPlugin>[] references = this.pluginTracker.getServiceReferences();
        int i = 0;
        while (i < references.length) {
            block7: {
                ConfigurationPlugin plugin;
                block6: {
                    String[] pids = (String[])references[i].getProperty("cm.target");
                    if (pids == null) break block6;
                    String pid = (String)properties.get("service.pid");
                    if (!Arrays.asList(pids).contains(pid)) break block7;
                }
                if ((plugin = (ConfigurationPlugin)this.pluginTracker.getService(references[i])) != null) {
                    plugin.modifyConfiguration(managedReference, properties);
                }
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PluginTracker
    extends ServiceTracker<ConfigurationPlugin, ConfigurationPlugin> {
        final Integer ZERO = 0;
        private TreeSet<ServiceReference<ConfigurationPlugin>> serviceReferences = new TreeSet<ServiceReference<ConfigurationPlugin>>(new Comparator<ServiceReference<ConfigurationPlugin>>(){

            @Override
            public int compare(ServiceReference<ConfigurationPlugin> s1, ServiceReference<ConfigurationPlugin> s2) {
                int rankCompare = this.getRank(s1).compareTo(this.getRank(s2));
                if (rankCompare != 0) {
                    return rankCompare;
                }
                return -s1.compareTo(s2);
            }

            private Integer getRank(ServiceReference<ConfigurationPlugin> ref) {
                Object ranking = ref.getProperty("service.cmRanking");
                if (ranking == null || !(ranking instanceof Integer)) {
                    return PluginTracker.this.ZERO;
                }
                return (Integer)ranking;
            }
        });

        public PluginTracker(BundleContext context) {
            super(context, ConfigurationPlugin.class.getName(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceReference<ConfigurationPlugin>[] getServiceReferences() {
            TreeSet<ServiceReference<ConfigurationPlugin>> treeSet = this.serviceReferences;
            synchronized (treeSet) {
                return this.serviceReferences.toArray(new ServiceReference[this.serviceReferences.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConfigurationPlugin addingService(ServiceReference<ConfigurationPlugin> reference) {
            TreeSet<ServiceReference<ConfigurationPlugin>> treeSet = this.serviceReferences;
            synchronized (treeSet) {
                this.serviceReferences.add(reference);
            }
            return (ConfigurationPlugin)this.context.getService(reference);
        }

        public void modifiedService(ServiceReference<ConfigurationPlugin> reference, ConfigurationPlugin service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ConfigurationPlugin> reference, ConfigurationPlugin service) {
            TreeSet<ServiceReference<ConfigurationPlugin>> treeSet = this.serviceReferences;
            synchronized (treeSet) {
                this.serviceReferences.remove(reference);
            }
            this.context.ungetService(reference);
        }
    }
}

