/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.rap.internal.design.example.Messages;
import org.eclipse.rap.ui.interactiondesign.layout.ElementBuilder;
import org.eclipse.rap.ui.internal.preferences.SessionScope;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.Graphics;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.osgi.service.prefs.BackingStoreException;

public class PerspectiveSwitcherBuilder
extends ElementBuilder {
    private static final String RAP_PERSPECTIVES = "RAP_PERSPECTIVES";
    private final Composite background;
    private final Map perspectiveButtonMap;
    private final Map buttonPerspectiveMap;
    private final List buttonList;
    private final List perspectiveList;
    private Button otherButton;
    private final Image left;
    private final Image right;
    private final Image bg;
    private final Image bgActive;
    private final PerspectiveAdapter perspectiveAdapter = new PerspectiveAdapter(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            PerspectiveSwitcherBuilder.this.addIdToStore(perspective.getId());
            Button button = PerspectiveSwitcherBuilder.this.createPerspectiveButton(perspective);
            PerspectiveSwitcherBuilder.this.cleanButtons(button);
            PerspectiveSwitcherBuilder.this.background.layout(true);
            Control[] children = new Control[]{PerspectiveSwitcherBuilder.this.background};
            Composite parent = PerspectiveSwitcherBuilder.this.getParent();
            parent.changed(children);
            parent.layout(true);
            parent.getParent().layout(true);
        }
    };

    public PerspectiveSwitcherBuilder(Composite parent, String subSetId) {
        super(parent, subSetId);
        this.background = new Composite(parent, 0);
        this.background.setData("org.eclipse.rap.rwt.customVariant", (Object)"compTrans");
        RowLayout layout = new RowLayout();
        this.background.setLayout((Layout)layout);
        layout.spacing = 3;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        this.perspectiveButtonMap = new HashMap();
        this.buttonPerspectiveMap = new HashMap();
        this.buttonList = new ArrayList();
        this.perspectiveList = new ArrayList();
        this.left = this.getImage("perspective.left.active");
        this.right = this.getImage("perspective.right.active");
        this.bg = this.getImage("perspective.bg");
        this.bgActive = this.getImage("perspective.bg.active");
    }

    public void addControl(Control control, Object layoutData) {
    }

    public void addControl(Control control, String positionId) {
    }

    private void addIdToStore(String id) {
        if (!this.perspectiveList.contains(id)) {
            this.perspectiveList.add(id);
        }
        this.save();
    }

    public void addImage(Image image, Object layoutData) {
    }

    public void addImage(Image image, String positionId) {
    }

    public void build() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        workbenchWindow.addPerspectiveListener((IPerspectiveListener)this.perspectiveAdapter);
        IPerspectiveDescriptor[] descriptors = this.load();
        int i = 0;
        while (i < descriptors.length) {
            this.createPerspectiveButton(descriptors[i]);
            ++i;
        }
        Composite otherBg = new Composite(this.background, 0);
        otherBg.setLayout((Layout)new FormLayout());
        this.otherButton = new Button(otherBg, 0x800008);
        FormData fdOther = new FormData();
        this.otherButton.setLayoutData((Object)fdOther);
        fdOther.left = new FormAttachment(0, this.left.getBounds().width);
        FormData buttonPos = this.getLayoutSet().getPosition("perspective.button.position");
        fdOther.top = buttonPos.top;
        this.otherButton.setData("org.eclipse.rap.rwt.customVariant", (Object)"perspective");
        this.otherButton.setText(Messages.get().PerspectiveSwitcherBuilder_Other);
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        final ActionFactory.IWorkbenchAction perspectiveAction = ActionFactory.OPEN_PERSPECTIVE_DIALOG.create(activeWindow);
        this.otherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                perspectiveAction.run();
            }
        });
    }

    private void cleanButtons(Button current) {
        int i = 0;
        while (i < this.buttonList.size()) {
            int j;
            Button button = (Button)this.buttonList.get(i);
            Composite parent = button.getParent();
            Control[] children = parent.getChildren();
            if (!button.equals(current)) {
                j = 0;
                while (j < children.length) {
                    if (children[j] instanceof Label) {
                        children[j].setVisible(false);
                    }
                    ++j;
                }
                parent.setBackgroundImage(this.bg);
                button.setData("org.eclipse.rap.rwt.customVariant", (Object)"perspective");
            } else {
                j = 0;
                while (j < children.length) {
                    children[j].setVisible(true);
                    ++j;
                }
                parent.setBackgroundImage(this.bgActive);
                button.setData("org.eclipse.rap.rwt.customVariant", (Object)"perspectiveActive");
            }
            parent.layout(true);
            ++i;
        }
    }

    private void cleanUpButton(IPerspectiveDescriptor perspective, Button button) {
        this.buttonList.remove(button);
        this.perspectiveButtonMap.remove(perspective);
        this.buttonPerspectiveMap.remove(button);
        button.getParent().dispose();
        this.background.layout(true);
        Control[] children = new Control[]{this.background};
        Composite parent = this.getParent();
        parent.changed(children);
        parent.layout(true);
        parent.getParent().layout(true);
    }

    private void closePerspective(IPerspectiveDescriptor desc) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = workbenchWindow.getActivePage();
        activePage.closePerspective(desc, true, false);
    }

    private Button createPerspectiveButton(final IPerspectiveDescriptor desc) {
        Button result = (Button)this.perspectiveButtonMap.get(desc);
        if (result == null && desc != null && desc.getLabel() != null) {
            Composite buttonBg = new Composite(this.background, 0);
            buttonBg.setBackground(Graphics.getColor((int)247, (int)247, (int)247));
            buttonBg.setLayout((Layout)new FormLayout());
            Label leftBg = new Label(buttonBg, 0);
            leftBg.setImage(this.left);
            FormData fdLeftBg = new FormData();
            leftBg.setLayoutData((Object)fdLeftBg);
            fdLeftBg.top = new FormAttachment(0);
            fdLeftBg.left = new FormAttachment(0);
            fdLeftBg.height = this.left.getBounds().height;
            fdLeftBg.width = this.left.getBounds().width;
            Label rightBg = new Label(buttonBg, 0);
            rightBg.setImage(this.right);
            FormData fdRightBg = new FormData();
            rightBg.setLayoutData((Object)fdRightBg);
            fdRightBg.top = new FormAttachment(0);
            fdRightBg.height = this.right.getBounds().height;
            fdRightBg.width = this.right.getBounds().width;
            final Button perspButton = new Button(buttonBg, 0x800008);
            perspButton.setData("org.eclipse.rap.rwt.customVariant", (Object)"perspective");
            FormData fdButton = new FormData();
            perspButton.setLayoutData((Object)fdButton);
            fdButton.left = new FormAttachment((Control)leftBg);
            FormData buttonPos = this.getLayoutSet().getPosition("perspective.button.position");
            fdButton.top = buttonPos.top;
            fdRightBg.left = new FormAttachment((Control)perspButton);
            perspButton.setText(desc.getLabel());
            this.perspectiveButtonMap.put(desc, perspButton);
            this.buttonPerspectiveMap.put(perspButton, desc);
            this.buttonList.add(perspButton);
            perspButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PerspectiveSwitcherBuilder.this.cleanButtons(perspButton);
                    PerspectiveSwitcherBuilder.this.switchPerspective(desc.getId());
                }
            });
            Menu menu = new Menu((Control)perspButton);
            MenuItem item = new MenuItem(menu, 8);
            item.setText(Messages.get().PerspectiveSwitcherBuilder_Close);
            item.setImage(this.getImage("perspective.close"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PerspectiveSwitcherBuilder.this.removeIdFromStore(desc.getId());
                    Button button = (Button)PerspectiveSwitcherBuilder.this.perspectiveButtonMap.get(desc);
                    if (button != null) {
                        PerspectiveSwitcherBuilder.this.cleanUpButton(desc, button);
                    }
                    PerspectiveSwitcherBuilder.this.closePerspective(desc);
                    PerspectiveSwitcherBuilder.this.background.layout();
                }
            });
            perspButton.setMenu(menu);
            if (this.otherButton != null) {
                this.otherButton.getParent().moveBelow((Control)perspButton.getParent());
            }
            result = perspButton;
        }
        return result;
    }

    private IEclipsePreferences createSessionScope() {
        return new SessionScope().getNode(RAP_PERSPECTIVES);
    }

    public void dispose() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        workbenchWindow.removePerspectiveListener((IPerspectiveListener)this.perspectiveAdapter);
        Composite parent = this.getParent();
        if (parent != null && !parent.isDisposed()) {
            parent.dispose();
        }
    }

    public Control getControl() {
        return this.background;
    }

    public Point getSize() {
        return null;
    }

    private IPerspectiveDescriptor[] load() {
        IEclipsePreferences store = this.createSessionScope();
        IPerspectiveDescriptor[] result = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPerspectiveRegistry registry = workbench.getPerspectiveRegistry();
        try {
            String[] keys = store.keys();
            result = new IPerspectiveDescriptor[keys.length];
            int i = 0;
            while (i < keys.length) {
                String perspectiveId = keys[i];
                int pos = store.getInt(perspectiveId, 0);
                if (pos <= this.perspectiveList.size()) {
                    this.perspectiveList.add(pos, perspectiveId);
                } else {
                    this.perspectiveList.add(perspectiveId);
                }
                ++i;
            }
            i = 0;
            while (i < this.perspectiveList.size()) {
                String id = (String)this.perspectiveList.get(i);
                result[i] = registry.findPerspectiveWithId(id);
                ++i;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void removeIdFromStore(String id) {
        this.perspectiveList.remove(id);
        IEclipsePreferences store = this.createSessionScope();
        store.remove(id);
        this.save();
    }

    private void save() {
        IEclipsePreferences store = this.createSessionScope();
        try {
            store.clear();
            int i = 0;
            while (i < this.perspectiveList.size()) {
                String id = (String)this.perspectiveList.get(i);
                store.putInt(id, i);
                ++i;
            }
            store.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private void switchPerspective(String perspectiveId) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        try {
            workbench.showPerspective(perspectiveId, window);
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
    }
}

