/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;

public class URLTransfer
extends ByteArrayTransfer {
    static final String TYPE_NAME = "url";
    static final int TYPE_ID = URLTransfer.registerType("url");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return SingletonUtil.getSessionInstance(URLTransfer.class);
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = 1;
        try {
            transferData.data = new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            transferData.result = 0;
        }
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.result != 1) {
            return null;
        }
        return ((URL)transferData.data).toString();
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

