/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Elements {
    private static String[] SERIES_NAMES = new String[]{"Unknown", "Alkali metal", "Alkaline earth metal", "Halogen", "Noble gas", "Lanthanide", "Actinide", "Transition metal", "Poor metal", "Metalloid", "Nonmetal"};
    private static String[] SERIES_IDS = new String[]{"Unknown", "AM", "AEM", "H", "NG", "L", "A", "TM", "M", "MO", "NM"};
    private static List<Element> elements = new ArrayList<Element>();

    static {
        ClassLoader classLoader = Elements.class.getClassLoader();
        String resourceFileName = "resources/elements.csv";
        InputStream stream = classLoader.getResourceAsStream(resourceFileName);
        BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts = line.split("\t");
                    if (parts.length <= 0) continue;
                    int number = Integer.parseInt(parts[0]);
                    int group = Integer.parseInt(parts[1]);
                    int period = Integer.parseInt(parts[2]);
                    String symbol = parts[3];
                    String name = parts[4];
                    int series = Elements.readCategory(parts[5]);
                    Element element = new Element(number, period, group, series, symbol, name);
                    elements.add(element);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        finally {
            try {
                bufferedStream.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static int readCategory(String string) {
        int result = 0;
        int i = 1;
        while (i < SERIES_IDS.length && result == 0) {
            if (SERIES_IDS[i].equals(string)) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public static List<Element> getElements() {
        return new ArrayList<Element>(elements);
    }

    public static class Element {
        public final int number;
        public final int period;
        public final int group;
        public final int series;
        public final String symbol;
        public final String name;

        Element(int number, int period, int group, int series, String symbol, String name) {
            this.number = number;
            this.period = period;
            this.group = group;
            this.series = series;
            this.symbol = symbol;
            this.name = name;
        }

        public String getSeriesName() {
            return SERIES_NAMES[this.series];
        }
    }
}

