/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.SingletonManager;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.client.ClientMessages;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;

public class UISessionBuilder {
    private final ServiceContext serviceContext;
    private final UISessionImpl uiSession;

    public UISessionBuilder(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        ApplicationContextImpl applicationContext = serviceContext.getApplicationContext();
        HttpServletRequest request = serviceContext.getRequest();
        HttpSession httpSession = request.getSession(true);
        this.uiSession = new UISessionImpl(applicationContext, httpSession, UISessionBuilder.generateConnectionId());
    }

    public UISessionImpl buildUISession() {
        this.uiSession.attachToHttpSession();
        this.serviceContext.setUISession(this.uiSession);
        SingletonManager.install(this.uiSession);
        MeasurementUtil.installMeasurementOperator(this.uiSession);
        this.setCurrentTheme();
        this.selectClient();
        this.updateClientMessages();
        this.renderConnectionId();
        return this.uiSession;
    }

    private void setCurrentTheme() {
        String servletPath = this.serviceContext.getRequest().getServletPath();
        ThemeUtil.setCurrentThemeId(this.uiSession, ThemeUtil.getThemeIdFor(servletPath));
    }

    private void selectClient() {
        ApplicationContextImpl applicationContext = this.uiSession.getApplicationContext();
        applicationContext.getClientSelector().selectClient(this.serviceContext.getRequest(), this.uiSession);
    }

    private void updateClientMessages() {
        ClientMessages clientMessages = this.uiSession.getClient().getService(ClientMessages.class);
        if (clientMessages != null) {
            clientMessages.update(this.uiSession.getLocale());
        }
    }

    private void renderConnectionId() {
        String connectionId = this.uiSession.getConnectionId();
        this.serviceContext.getProtocolWriter().appendHead("cid", connectionId);
    }

    private static String generateConnectionId() {
        return UUID.randomUUID().toString().substring(0, 8);
    }
}

