/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarConfiguration;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.ClientFileLoader;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.Connection;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class RichTextEditor
extends Composite {
    private static final String RESOURCES_PATH = "resources/";
    private static final String REGISTER_PATH = "ckeditor/";
    private static final String[] RESOURCE_FILES = new String[]{"ckeditor.js", "config.js", "styles.js", "contents.css", "skins/moono/editor.css", "skins/moono/editor_ie.css", "skins/moono/editor_gecko.css", "skins/moono/dialog.css", "skins/moono/dialog_ie.css", "skins/moono/icons.png", "skins/moono/icons_hidpi.png", "skins/moono/images/arrow.png", "skins/moono/images/close.png", "skins/moono/images/lock-open.png", "skins/moono/images/lock.png", "skins/moono/images/refresh.png", "skins/moono/images/hidpi/close.png", "skins/moono/images/hidpi/lock-open.png", "skins/moono/images/hidpi/lock.png", "skins/moono/images/hidpi/refresh.png", "RichTextEditor.js", "RichTextEditorHandler.js"};
    private static final String REMOTE_TYPE = "rwt.widgets.RichTextEditor";
    private String text = "";
    private boolean editable = true;
    private final RemoteObject remoteObject;
    private final OperationHandler operationHandler = new AbstractOperationHandler(){

        public void handleSet(JsonObject properties) {
            JsonValue textValue = properties.get("text");
            if (textValue != null) {
                RichTextEditor.this.text = textValue.asString();
            }
        }
    };
    private final RichTextEditorConfiguration config;

    public RichTextEditor(Composite parent) {
        this(parent, 0);
    }

    public RichTextEditor(Composite parent, int style) {
        this(parent, (RichTextEditorConfiguration)null, style);
    }

    @Deprecated
    public RichTextEditor(Composite parent, ToolbarConfiguration toolbarConfig) {
        this(parent, toolbarConfig, 0);
    }

    @Deprecated
    public RichTextEditor(Composite parent, ToolbarConfiguration toolbarConfig, int style) {
        this(parent, toolbarConfig != null ? new RichTextEditorConfiguration(toolbarConfig) : null, style);
    }

    public RichTextEditor(Composite parent, RichTextEditorConfiguration editorConfig) {
        this(parent, editorConfig, 0);
    }

    public RichTextEditor(Composite parent, RichTextEditorConfiguration editorConfig, int style) {
        super(parent, style);
        this.config = editorConfig == null ? new RichTextEditorConfiguration() : editorConfig;
        this.registerResources();
        RichTextEditor.loadJavaScript();
        Connection connection = RWT.getUISession().getConnection();
        this.remoteObject = connection.createRemoteObject(REMOTE_TYPE);
        this.remoteObject.setHandler(this.operationHandler);
        this.remoteObject.set("parent", WidgetUtil.getId((Widget)this));
        this.remoteObject.set("config", (JsonValue)this.config.toJson());
    }

    private void registerResources() {
        ResourceManager resourceManager = RWT.getResourceManager();
        String[] stringArray = RESOURCE_FILES;
        int n = RESOURCE_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            RichTextEditor.registerFileIfNeeded(resourceManager, fileName);
            ++n2;
        }
        String lang = (String)this.config.getOption("language");
        String defaultLang = (String)this.config.getOption("defaultLanguage");
        RichTextEditor.registerFileIfNeeded(resourceManager, "lang/" + lang + ".js");
        RichTextEditor.registerFileIfNeeded(resourceManager, "lang/" + defaultLang + ".js");
    }

    private static void registerFileIfNeeded(ResourceManager resourceManager, String fileName) {
        boolean isRegistered = resourceManager.isRegistered(REGISTER_PATH + fileName);
        if (!isRegistered) {
            try {
                RichTextEditor.register(resourceManager, fileName);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Failed to load resources", ioe);
            }
        }
    }

    private static void loadJavaScript() {
        ClientFileLoader loader = (ClientFileLoader)RWT.getClient().getService(ClientFileLoader.class);
        ResourceManager resourceManager = RWT.getResourceManager();
        loader.requireJs(resourceManager.getLocation("ckeditor/ckeditor.js"));
        loader.requireJs(resourceManager.getLocation("ckeditor/config.js"));
        loader.requireJs(resourceManager.getLocation("ckeditor/RichTextEditor.js"));
        loader.requireJs(resourceManager.getLocation("ckeditor/RichTextEditorHandler.js"));
    }

    private static void register(ResourceManager resourceManager, String fileName) throws IOException {
        ClassLoader classLoader = RichTextEditor.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(RESOURCES_PATH + fileName);){
            resourceManager.register(REGISTER_PATH + fileName, inputStream);
        }
    }

    public RichTextEditorConfiguration getEditorConfiguration() {
        return this.config;
    }

    public void setLayout(Layout layout) {
        throw new UnsupportedOperationException("Cannot change internal layout of RichTextEditor");
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.remoteObject.set("font", this.getCssFont());
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.remoteObject.destroy();
        }
        super.dispose();
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error((int)4);
        }
        this.text = text;
        this.remoteObject.set("text", text);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean isEditable() {
        this.checkWidget();
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        if (this.editable != editable) {
            this.editable = editable;
            this.remoteObject.set("editable", editable);
        }
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    private String getCssFont() {
        StringBuilder result = new StringBuilder();
        if (this.getFont() != null) {
            FontData data = this.getFont().getFontData()[0];
            result.append(data.getHeight());
            result.append("px ");
            result.append(data.getName());
        }
        return result.toString();
    }
}

