/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.resources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ClientFilesReader {
    private static final String CHARSET = "UTF-8";
    private final String resourceName;
    private final ArrayList<String> files;

    public static final List<String> getInputFiles(String resourceName) {
        ClientFilesReader reader = new ClientFilesReader(resourceName);
        try {
            reader.read();
        }
        catch (IOException exception) {
            String message = "Failed to read input list from " + resourceName;
            throw new RuntimeException(message, exception);
        }
        return reader.getFiles();
    }

    ClientFilesReader(String resourceName) {
        this.resourceName = resourceName;
        this.files = new ArrayList();
    }

    InputStream openInputStream() throws IOException {
        ClassLoader classLoader = ClientFilesReader.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this.resourceName);
        if (inputStream == null) {
            throw new IOException("Resource not found: " + this.resourceName);
        }
        return inputStream;
    }

    void read() throws IOException {
        try (InputStream inputStream = this.openInputStream();){
            this.readLines(inputStream);
        }
    }

    List<String> getFiles() {
        return this.files;
    }

    private void readLines(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, CHARSET));
        String line = reader.readLine();
        while (line != null) {
            this.readLine(line);
            line = reader.readLine();
        }
    }

    private void readLine(String line) {
        String text = line.trim();
        if (text.length() > 0 && !text.startsWith("#")) {
            this.files.add(text);
        }
    }
}

