/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FactoryOverrideRegistryReader
extends RegistryReader {
    static final String TAG_FACTORY = "factory";
    static final String ATT_URI = "uri";
    static final String ATT_CLASS = "class";
    static final String ATT_PREDECESSOR = "predecessor";

    public FactoryOverrideRegistryReader() {
        super(RegistryFactory.getRegistry(), EcorePlugin.INSTANCE.getSymbolicName(), "factory_override");
    }

    @Override
    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_FACTORY)) {
            String packageURI = element.getAttribute(ATT_URI);
            if (packageURI == null) {
                this.logMissingAttribute(element, ATT_URI);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                if (add) {
                    Object ePackageDescriptor = EPackage.Registry.INSTANCE.get(packageURI);
                    if (ePackageDescriptor instanceof EPackage.Descriptor) {
                        if (ePackageDescriptor instanceof RegistryReader.EFactoryDescriptor) {
                            RegistryReader.EFactoryDescriptor oldFactoryDescriptor = (RegistryReader.EFactoryDescriptor)ePackageDescriptor;
                            Set<String> oldPredecessors = FactoryOverrideRegistryReader.getPredecessors(oldFactoryDescriptor.element);
                            if (oldPredecessors.contains(element.getAttribute(ATT_CLASS))) {
                                return true;
                            }
                            Set<String> newPredecessors = FactoryOverrideRegistryReader.getPredecessors(element);
                            if (!newPredecessors.contains(oldFactoryDescriptor.element.getAttribute(ATT_CLASS))) {
                                EcorePlugin.INSTANCE.log("Both '" + oldFactoryDescriptor.element.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a factory override for '" + packageURI + "'");
                            }
                        }
                        RegistryReader.EFactoryDescriptor newFactoryDescriptor = new RegistryReader.EFactoryDescriptor(element, ATT_CLASS, (EPackage.Descriptor)ePackageDescriptor);
                        EPackage.Registry.INSTANCE.put(packageURI, newFactoryDescriptor);
                    }
                    return true;
                }
                Object ePackageDescriptor = EPackage.Registry.INSTANCE.get(packageURI);
                if (ePackageDescriptor instanceof RegistryReader.EFactoryDescriptor) {
                    EPackage.Registry.INSTANCE.put(packageURI, ((RegistryReader.EFactoryDescriptor)ePackageDescriptor).getOverridenDescriptor());
                }
                return true;
            }
        }
        return false;
    }

    private static Set<String> getPredecessors(IConfigurationElement element) {
        String value = element.getAttribute(ATT_PREDECESSOR);
        if (value == null) {
            return Collections.emptySet();
        }
        HashSet<String> predecessors = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(value, " ");
        while (tokenizer.hasMoreTokens()) {
            String predecessor = tokenizer.nextToken().trim();
            if (predecessor.length() == 0) continue;
            predecessors.add(predecessor);
        }
        return predecessors;
    }
}

