/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.event;

import org.eclipse.equinox.internal.event.EventComponent;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;

public class Activator
implements BundleActivator {
    private static final String PROP_USE_DS = "equinox.use.ds";
    private ServiceRegistration<EventAdmin> eventAdminService;
    private EventComponent eventAdmin;

    public void start(BundleContext bundleContext) throws InvalidSyntaxException {
        if (Boolean.valueOf(bundleContext.getProperty(PROP_USE_DS)).booleanValue()) {
            return;
        }
        String serviceName = EventAdmin.class.getName();
        Filter serviceFilter = bundleContext.createFilter("(objectclass=" + serviceName + ")");
        ServiceReference[] refs = bundleContext.getBundle().getRegisteredServices();
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                if (serviceFilter.match(refs[i])) {
                    return;
                }
                ++i;
            }
        }
        this.eventAdmin = new EventComponent();
        this.eventAdmin.activate(bundleContext);
        this.eventAdminService = bundleContext.registerService(EventAdmin.class, (Object)this.eventAdmin, null);
    }

    public void stop(BundleContext bundleContext) {
        if (this.eventAdmin != null) {
            this.eventAdminService.unregister();
            this.eventAdmin.deactivate(bundleContext);
        }
    }
}

