/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import java.util.Arrays;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.pages.internal.ImageUtil;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class ListExample
implements IExamplePage {
    private static final int LIST_STYLE = 2562;
    private static final String IMG_ADD = "forward_nav.gif";
    private static final String IMG_REMOVE = "backward_nav.gif";
    private static final String[] ELEMENTS = new String[]{"Dansk", "Deutsch", "English", "Espa\u00f1ol", "Fran\u00e7ais", "Nederlands", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "Suomi", "Svenska"};

    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)3, (boolean)false, (boolean)true, (boolean)true));
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        final List leftList = new List(composite, 2562);
        leftList.setLayoutData((Object)ExampleUtil.createFillData());
        ListExample.addDragSupport(leftList);
        ListExample.addDropSupport(leftList);
        Composite buttons = new Composite(composite, 0);
        RowLayout layout = new RowLayout(512);
        layout.fill = true;
        buttons.setLayout((Layout)layout);
        Button addButton = this.createButton(buttons, "Add", IMG_ADD);
        Button removeButton = this.createButton(buttons, "Remove", IMG_REMOVE);
        final List rightList = new List(composite, 2562);
        rightList.setLayoutData((Object)ExampleUtil.createFillData());
        ListExample.addDragSupport(rightList);
        ListExample.addDropSupport(rightList);
        leftList.setItems(ELEMENTS);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ListExample.moveSelectedItems(leftList, rightList);
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ListExample.moveSelectedItems(rightList, leftList);
            }
        });
    }

    private static void addDragSupport(final List list) {
        DragSource dragSource = new DragSource((Control)list, 2);
        dragSource.setTransfer(new Transfer[]{new StringArrayTransfer()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                event.data = list.getSelection();
            }

            public void dragFinished(DragSourceEvent event) {
                if (event.detail == 2) {
                    String[] items = list.getSelection();
                    int i = 0;
                    while (i < items.length) {
                        list.remove(items[i]);
                        ++i;
                    }
                }
            }
        });
    }

    private static void addDropSupport(final List list) {
        DropTarget dropTarget = new DropTarget((Control)list, 2);
        dropTarget.setTransfer(new Transfer[]{new StringArrayTransfer()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] items = (String[])event.data;
                int i = 0;
                while (i < items.length) {
                    list.add(items[i]);
                    ++i;
                }
            }
        });
    }

    private Button createButton(Composite parent, String text, String image) {
        Button result = new Button(parent, 16392);
        result.setText(text);
        result.setImage(ImageUtil.getImage((Device)result.getDisplay(), image));
        return result;
    }

    private static void moveSelectedItems(List srcList, List dstList) {
        String[] selection = srcList.getSelection();
        int i = 0;
        while (i < selection.length) {
            String item = selection[i];
            srcList.remove(item);
            dstList.add(item);
            ++i;
        }
        if (selection.length > 0) {
            srcList.deselectAll();
            ListExample.sortItems(dstList);
            dstList.setSelection(selection);
        }
    }

    private static void sortItems(List srcList) {
        Object[] items = srcList.getItems();
        Arrays.sort(items);
        srcList.setItems((String[])items);
    }

    private static final class StringArrayTransfer
    extends ByteArrayTransfer {
        private static final String TYPE_NAME = "string-array";
        private static final int TYPE_ID = StringArrayTransfer.registerType((String)"string-array");

        private StringArrayTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPE_ID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }

        public void javaToNative(Object object, TransferData transferData) {
            transferData.data = object;
        }

        public Object nativeToJava(TransferData transferData) {
            return transferData.data;
        }
    }
}

