/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.value;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.map.ComputedObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.identity.IdentitySet;
import org.eclipse.core.internal.databinding.property.Util;

public class SetSimpleValueObservableMap<S, K extends S, V>
extends ComputedObservableMap<K, V>
implements IPropertyObservable<SimpleValueProperty<S, V>> {
    private SimpleValueProperty<S, V> detailProperty;
    private INativePropertyListener<S> listener;
    private Map<K, V> cachedValues;
    private Set<K> staleKeys;
    private boolean updating;

    public SetSimpleValueObservableMap(IObservableSet<K> keySet, SimpleValueProperty<S, V> valueProperty) {
        super(keySet, valueProperty.getValueType());
        this.detailProperty = valueProperty;
    }

    protected void firstListenerAdded() {
        if (this.listener == null) {
            this.listener = this.detailProperty.adaptListener(event -> {
                if (!this.isDisposed() && !this.updating) {
                    this.getRealm().exec(() -> {
                        Object source = event.getSource();
                        if (simplePropertyEvent.type == SimplePropertyEvent.CHANGE) {
                            this.notifyIfChanged(source);
                        } else if (simplePropertyEvent.type == SimplePropertyEvent.STALE) {
                            boolean wasStale = !this.staleKeys.isEmpty();
                            this.staleKeys.add(source);
                            if (!wasStale) {
                                this.fireStale();
                            }
                        }
                    });
                }
            });
        }
        this.cachedValues = new IdentityMap();
        this.staleKeys = new IdentitySet();
        super.firstListenerAdded();
    }

    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        this.cachedValues.clear();
        this.cachedValues = null;
        this.staleKeys.clear();
        this.staleKeys = null;
    }

    protected void hookListener(K addedKey) {
        if (this.cachedValues != null) {
            this.cachedValues.put(addedKey, this.detailProperty.getValue(addedKey));
            if (this.listener != null) {
                this.listener.addTo(addedKey);
            }
        }
    }

    protected void unhookListener(K removedKey) {
        if (this.cachedValues != null) {
            if (this.listener != null) {
                this.listener.removeFrom(removedKey);
            }
            this.cachedValues.remove(removedKey);
            this.staleKeys.remove(removedKey);
        }
    }

    protected V doGet(Object key) {
        return (V)this.detailProperty.getValue(key);
    }

    protected V doPut(K key, V value) {
        Object oldValue = this.detailProperty.getValue(key);
        this.updating = true;
        try {
            this.detailProperty.setValue(key, value);
        }
        finally {
            this.updating = false;
        }
        this.notifyIfChanged(key);
        return (V)oldValue;
    }

    private void notifyIfChanged(K key) {
        Object newValue;
        V oldValue;
        if (this.cachedValues != null && (!Util.equals(oldValue = this.cachedValues.get(key), newValue = this.detailProperty.getValue(key)) || this.staleKeys.contains(key))) {
            this.cachedValues.put(key, newValue);
            this.staleKeys.remove(key);
            this.fireMapChange(Diffs.createMapDiffSingleChange(key, oldValue, newValue));
        }
    }

    public Object getObserved() {
        return this.keySet();
    }

    @Override
    public SimpleValueProperty<S, V> getProperty() {
        return this.detailProperty;
    }

    public boolean isStale() {
        return super.isStale() || this.staleKeys != null && !this.staleKeys.isEmpty();
    }

    public synchronized void dispose() {
        if (this.cachedValues != null) {
            this.cachedValues.clear();
            this.cachedValues = null;
        }
        this.listener = null;
        this.detailProperty = null;
        this.cachedValues = null;
        this.staleKeys = null;
        super.dispose();
    }
}

