/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.AbstractResourceManager;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public final class DeviceResourceManager
extends AbstractResourceManager {
    private Device device;
    private Image missingImage;

    @Override
    public Device getDevice() {
        return this.device;
    }

    public DeviceResourceManager(Device device) {
        this.device = device;
    }

    @Override
    protected Object allocate(DeviceResourceDescriptor descriptor) throws DeviceResourceException {
        return descriptor.createResource(this.device);
    }

    @Override
    protected void deallocate(Object resource, DeviceResourceDescriptor descriptor) {
        descriptor.destroyResource(resource);
    }

    @Override
    protected Image getDefaultImage() {
        if (this.missingImage == null) {
            this.missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.missingImage;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.missingImage != null) {
            this.missingImage = null;
        }
    }
}

