/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.toolbarkit.ToolBarLCA;
import org.eclipse.swt.internal.widgets.toolbarkit.ToolBarThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBar
extends Composite {
    private static final int DEFAULT_TOOLBAR_WIDTH = 24;
    private static final int DEFAULT_TOOLBAR_HEIGHT = 22;
    private final ItemHolder<ToolItem> itemHolder;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        this.itemHolder = new ItemHolder<ToolItem>(ToolItem.class);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IItemHolderAdapter.class) {
            return (T)this.itemHolder;
        }
        if (adapter == WidgetLCA.class) {
            return (T)ToolBarLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        return this.itemHolder.getItem(index);
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem result = null;
        ToolItem[] items = this.getItems();
        int i = 0;
        while (result == null && i < items.length) {
            Rectangle rect = items[i].getBounds();
            if (rect.contains(point)) {
                result = items[i];
            }
            ++i;
        }
        return result;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemHolder.size();
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return (ToolItem[])this.itemHolder.getItems();
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        return this.itemHolder.indexOf(item);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 0x200) != 0) {
            i = 0;
            while (i < this.itemHolder.size()) {
                item = this.itemHolder.getItem(i);
                itemBounds = item.getBounds();
                width = Math.max(width, itemBounds.width);
                if (i == this.itemHolder.size() - 1) {
                    height += itemBounds.height + itemBounds.y;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.itemHolder.size()) {
                item = this.itemHolder.getItem(i);
                itemBounds = item.getBounds();
                height = Math.max(height, itemBounds.height);
                if (i == this.itemHolder.size() - 1) {
                    width += itemBounds.width + itemBounds.x;
                }
                ++i;
            }
        }
        BoxDimensions toolBarPadding = this.getToolBarPadding();
        height += toolBarPadding.top + toolBarPadding.bottom;
        if ((width += toolBarPadding.left + toolBarPadding.right) == 0) {
            width = 24;
        }
        if (height == 0) {
            height = 22;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int i = 0;
        while (i < this.itemHolder.size()) {
            ToolItem item = this.itemHolder.getItem(i);
            item.resizeControl();
            ++i;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = trim.width;
        height = trim.height;
        return new Point(width, height);
    }

    BoxDimensions getToolBarPadding() {
        ToolBarThemeAdapter themeAdapter = (ToolBarThemeAdapter)this.getAdapter(ThemeAdapter.class);
        return themeAdapter.getToolBarPadding(this);
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        Point oldSize = this.getSize();
        super.setBounds(bounds);
        if (!oldSize.equals(this.getSize())) {
            this.layoutItems();
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.layoutItems();
    }

    @Override
    void removeChild(Control control) {
        super.removeChild(control);
        ToolItem[] items = (ToolItem[])this.itemHolder.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null && item.getControl() == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    @Override
    final void releaseChildren() {
        ToolItem[] toolItems = (ToolItem[])this.itemHolder.getItems();
        int i = 0;
        while (i < toolItems.length) {
            toolItems[i].dispose();
            ++i;
        }
    }

    private static int checkStyle(int style) {
        int result = style;
        if ((result & 0x800000) == 0) {
            result |= 0x80000;
        }
        return result & 0xFFFFFCFF;
    }

    void createItem(ToolItem item, int index) {
        this.itemHolder.insert(item, index);
        this.layoutItems();
    }

    void destroyItem(ToolItem item) {
        this.itemHolder.remove(item);
        this.layoutItems();
    }

    void layoutItems() {
        int i = 0;
        while (i < this.itemHolder.size()) {
            ToolItem item = this.itemHolder.getItem(i);
            Rectangle ibounds = item.getBounds();
            Rectangle bounds = this.getBounds();
            boolean hasEnoughWidth = ibounds.x + ibounds.width <= bounds.width;
            boolean hasEnoughHeight = ibounds.y + ibounds.height <= bounds.height;
            item.setVisible(hasEnoughWidth && hasEnoughHeight);
            item.resizeControl();
            ++i;
        }
    }

    @Override
    void reskinChildren(int flags) {
        ToolItem[] items = this.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                ToolItem item = items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }
}

