/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.pages.LoginDialog;
import org.eclipse.rap.examples.pages.MessageDialogUtil;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.rap.rwt.widgets.DialogUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class DialogExamplePage
implements IExamplePage {
    private Label resultsLabel;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        this.createSwtArea(parent);
        this.createJfaceArea(parent);
        this.createCustomArea(parent);
        this.createResultsComposite(parent);
    }

    private void createSwtArea(Composite parent) {
        Composite swtComp = new Composite(parent, 0);
        swtComp.setLayoutData((Object)ExampleUtil.createHorzFillData());
        swtComp.setLayout((Layout)ExampleUtil.createGridLayout((int)3, (boolean)false, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)swtComp, (String)"SWT Dialogs", (int)3);
        this.createSwtDialogButtons(swtComp);
    }

    private void createJfaceArea(Composite parent) {
        Composite jFaceComp = new Composite(parent, 0);
        jFaceComp.setLayoutData((Object)ExampleUtil.createHorzFillData());
        jFaceComp.setLayout((Layout)ExampleUtil.createGridLayout((int)3, (boolean)false, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)jFaceComp, (String)"JFace Dialogs", (int)3);
        this.createJfaceDialogButtons(jFaceComp);
    }

    private void createCustomArea(Composite parent) {
        Composite customComp = new Composite(parent, 0);
        customComp.setLayoutData((Object)ExampleUtil.createHorzFillData());
        customComp.setLayout((Layout)ExampleUtil.createGridLayout((int)3, (boolean)false, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)customComp, (String)"Custom Dialogs", (int)3);
        this.createCustomDialogs(customComp);
    }

    private void createResultsComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)3, (boolean)false, (boolean)true, (boolean)true));
        composite.setLayoutData((Object)ExampleUtil.createHorzFillData());
        this.resultsLabel = new Label(composite, 64);
        this.resultsLabel.setLayoutData((Object)ExampleUtil.createFillData());
    }

    private void createSwtDialogButtons(Composite swtComp) {
        this.createMessageDialogButton(swtComp);
        this.createColorDialogButton(swtComp);
        this.createFontDialogButton(swtComp);
    }

    private void createMessageDialogButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("MessageBox");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogExamplePage.this.showMessageBox();
            }
        });
        button.setLayoutData((Object)DialogExamplePage.createButtonGridData());
    }

    private void createColorDialogButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("ColorDialog");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogExamplePage.this.showColorDialog();
            }
        });
        button.setLayoutData((Object)DialogExamplePage.createButtonGridData());
    }

    private void createFontDialogButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("FontDialog");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogExamplePage.this.showFontDialog();
            }
        });
        button.setLayoutData((Object)DialogExamplePage.createButtonGridData());
    }

    private void createJfaceDialogButtons(Composite parent) {
        this.createInputDialogButton(parent);
        this.createProgressDialogButton(parent);
        this.createErrorDialogButton(parent);
        this.createInfoMessageDialogButton(parent);
        this.createWarningMessageDialogButton(parent);
        this.createErrorMessageDialogButton(parent);
        this.createQuestionMessageDialogButton(parent);
        this.createConfirmMessageDialogButton(parent);
    }

    private void createInputDialogButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Input Dialog");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogExamplePage.this.showInputDialog();
            }
        });
        button.setLayoutData((Object)DialogExamplePage.createButtonGridData());
    }

    private void createProgressDialogButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("ProgressDialog");
        button.setLayoutData((Object)DialogExamplePage.createButtonGridData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogExamplePage.this.showProgressDialog();
            }
        });
    }

    private void createErrorDialogButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)DialogExamplePage.createButtonGridData());
        button.setText("Error Dialog");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogExamplePage.this.showErrorDialog();
            }
        });
    }

    private void createInfoMessageDialogButton(Composite parent) {
        Button showMessageInfoDlgButton = new Button(parent, 8);
        showMessageInfoDlgButton.setLayoutData((Object)DialogExamplePage.createButtonGridData());
        showMessageInfoDlgButton.setText("Info Message");
        showMessageInfoDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogExamplePage.this.showMessageDialogInfo();
            }
        });
    }

    private void createWarningMessageDialogButton(Composite parent) {
        Button showMessageWarningDlgButton = new Button(parent, 8);
        showMessageWarningDlgButton.setLayoutData((Object)DialogExamplePage.createButtonGridData());
        showMessageWarningDlgButton.setText("Warning Dialog");
        showMessageWarningDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogExamplePage.this.showMessageDialogWarning();
            }
        });
    }

    private void createErrorMessageDialogButton(Composite parent) {
        Button showMessageErrorDlgButton = new Button(parent, 8);
        showMessageErrorDlgButton.setLayoutData((Object)DialogExamplePage.createButtonGridData());
        showMessageErrorDlgButton.setText("Error Message");
        showMessageErrorDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogExamplePage.this.showMessageDialogError();
            }
        });
    }

    private void createQuestionMessageDialogButton(Composite parent) {
        Button showMessageQuestionDlgButton = new Button(parent, 8);
        showMessageQuestionDlgButton.setLayoutData((Object)DialogExamplePage.createButtonGridData());
        showMessageQuestionDlgButton.setText("Question Dialog");
        showMessageQuestionDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogExamplePage.this.showMessageDialogQuestion();
            }
        });
    }

    private void createConfirmMessageDialogButton(Composite parent) {
        Button showMessageConfirmDlgButton = new Button(parent, 8);
        showMessageConfirmDlgButton.setLayoutData((Object)DialogExamplePage.createButtonGridData());
        showMessageConfirmDlgButton.setText("Confirm Message");
        showMessageConfirmDlgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogExamplePage.this.showMessageDialogConfirm();
            }
        });
    }

    private void createCustomDialogs(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Login Dialog");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogExamplePage.this.showLoginDialog();
            }
        });
        button.setLayoutData((Object)DialogExamplePage.createButtonGridData());
    }

    private void showInputDialog() {
        IInputValidator val = new IInputValidator(){

            public String isValid(String newText) {
                String result = null;
                if (newText.length() < 5) {
                    result = "Input text too short!";
                }
                return result;
            }
        };
        String title = "Input Dialog";
        String mesg = "Enter at least five characters";
        String def = "default text";
        InputDialog dialog = new InputDialog(this.getShell(), title, mesg, def, val){

            public boolean close() {
                boolean result = super.close();
                int returnCode = this.getReturnCode();
                String resultText = "Result: " + DialogExamplePage.this.getReturnCodeText(returnCode);
                if (returnCode == 0) {
                    resultText = String.valueOf(resultText) + ", value: " + this.getValue();
                }
                DialogExamplePage.this.showResult(resultText);
                return result;
            }
        };
        dialog.setBlockOnOpen(false);
        dialog.open();
    }

    private void showProgressDialog() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell()){

            public boolean close() {
                return super.close();
            }
        };
        dialog.setBlockOnOpen(false);
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Counting to 12...", 12);
                    int i = 1;
                    while (!monitor.isCanceled() && i <= 12) {
                        monitor.worked(1);
                        Thread.sleep(300L);
                        ++i;
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            MessageDialogUtil.openError(this.getShell(), "Error", e.getMessage(), null);
        }
    }

    private void showMessageDialogInfo() {
        String title = "Information";
        String message = "This is a RAP MessageDialog.";
        DialogCallback callback = new DialogCallback(){

            public void dialogClosed(int returnCode) {
                DialogExamplePage.this.showResult("Result: none");
            }
        };
        MessageDialogUtil.openInformation(this.getShell(), title, message, callback);
    }

    private void showMessageDialogError() {
        String title = "Error";
        String message = "A weird error occured.\n Please reboot.";
        DialogCallback callback = new DialogCallback(){

            public void dialogClosed(int returnCode) {
                DialogExamplePage.this.showResult("Result: none");
            }
        };
        MessageDialogUtil.openError(this.getShell(), title, message, callback);
    }

    private void showMessageDialogQuestion() {
        String title = "Question";
        String message = "Would you like to see the demo?\n\nYou can have multiple lines of text here. Note that pressing <Return> here selects the default button.";
        DialogCallback callback = new DialogCallback(){

            public void dialogClosed(int returnCode) {
                DialogExamplePage.this.showResult("Result: " + returnCode);
            }
        };
        MessageDialogUtil.openQuestion(this.getShell(), title, message, callback);
    }

    private void showMessageDialogConfirm() {
        String title = "Confirmation";
        String message = "Nothing will be done. Ok?";
        DialogCallback callback = new DialogCallback(){

            public void dialogClosed(int returnCode) {
                DialogExamplePage.this.showResult("Result: " + returnCode);
            }
        };
        MessageDialogUtil.openConfirm(this.getShell(), title, message, callback);
    }

    private void showMessageDialogWarning() {
        String title = "Warning";
        String message = "You have been warned.";
        DialogCallback callback = new DialogCallback(){

            public void dialogClosed(int returnCode) {
                DialogExamplePage.this.showResult("Result: " + returnCode);
            }
        };
        MessageDialogUtil.openWarning(this.getShell(), title, message, callback);
    }

    private void showErrorDialog() {
        MultiStatus status = DialogExamplePage.createStatus();
        String title = "Error";
        String message = "An error occured while processing this command";
        int displayMask = 7;
        ErrorDialog errorDialog = new ErrorDialog(this.getShell(), title, message, (IStatus)status, displayMask){

            public boolean close() {
                boolean result = super.close();
                int returnCode = this.getReturnCode();
                DialogExamplePage.this.showResult("Result: " + DialogExamplePage.this.getReturnCodeText(returnCode));
                return result;
            }
        };
        errorDialog.setBlockOnOpen(false);
        errorDialog.open();
    }

    private static MultiStatus createStatus() {
        String pluginId = "org.eclipse.rap.demo";
        int code = 23;
        String message = "Illegal array offset";
        MultiStatus multiStatus = new MultiStatus(pluginId, code, message, (Throwable)new RuntimeException());
        IndexOutOfBoundsException exception = new IndexOutOfBoundsException("negative index: -1");
        multiStatus.add((IStatus)new Status(4, pluginId, code, message, (Throwable)exception));
        return multiStatus;
    }

    private void showLoginDialog() {
        String message = "Please sign in with your username and password:";
        LoginDialog loginDialog = new LoginDialog(this.getShell(), "Login", message){

            public boolean close() {
                boolean result = super.close();
                int returnCode = this.getReturnCode();
                String resultText = "Result: " + DialogExamplePage.this.getReturnCodeText(returnCode);
                if (returnCode == 0) {
                    String pwInfo = this.getPassword() == null ? "n/a" : String.valueOf(this.getPassword().length()) + " chars";
                    resultText = String.valueOf(resultText) + ", user: " + this.getUsername() + ", password: " + pwInfo;
                }
                DialogExamplePage.this.showResult(resultText);
                return result;
            }
        };
        loginDialog.setUsername("john");
        loginDialog.setBlockOnOpen(false);
        loginDialog.open();
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }

    private String getReturnCodeText(int code) {
        String result = code == 0 ? "OK" : (code == 1 ? "CANCEL" : String.valueOf(code));
        return result;
    }

    private void showMessageBox() {
        String title = "MessageBox Title";
        String mesg = "Lorem ipsum dolor sit amet consectetuer adipiscing elit.";
        MessageBox messageBox = new MessageBox(this.getShell(), 192);
        messageBox.setText(title);
        messageBox.setMessage(mesg);
        DialogUtil.open((Dialog)messageBox, (DialogCallback)new DialogCallback(){

            public void dialogClosed(int returnCode) {
                String strResult = "";
                switch (returnCode) {
                    case 32: {
                        strResult = "SWT.OK";
                        break;
                    }
                    case 64: {
                        strResult = "SWT.YES";
                        break;
                    }
                    case 128: {
                        strResult = "SWT.NO";
                        break;
                    }
                    case 256: {
                        strResult = "SWT.CANCEL";
                        break;
                    }
                    case 512: {
                        strResult = "SWT.ABORT";
                        break;
                    }
                    case 1024: {
                        strResult = "SWT.RETRY";
                        break;
                    }
                    case 2048: {
                        strResult = "SWT.IGNORE";
                        break;
                    }
                    default: {
                        strResult = "" + returnCode;
                    }
                }
                DialogExamplePage.this.showResult("Result: " + strResult);
            }
        });
    }

    private void showColorDialog() {
        final ColorDialog dialog = new ColorDialog(this.getShell());
        DialogUtil.open((Dialog)dialog, (DialogCallback)new DialogCallback(){

            public void dialogClosed(int returnCode) {
                RGB result = dialog.getRGB();
                DialogExamplePage.this.showResult("Result: " + result);
            }
        });
    }

    protected void showFontDialog() {
        final FontDialog dialog = new FontDialog(this.getShell(), 1264);
        DialogUtil.open((Dialog)dialog, (DialogCallback)new DialogCallback(){

            public void dialogClosed(int returnCode) {
                FontData[] fontList = dialog.getFontList();
                FontData fontData = null;
                if (fontList != null) {
                    fontData = fontList[0];
                }
                DialogExamplePage.this.showResult("Result: " + fontData + " / " + dialog.getRGB());
            }
        });
    }

    private void showResult(String resultText) {
        this.resultsLabel.setText(resultText);
        this.resultsLabel.getParent().pack();
    }

    private static GridData createButtonGridData() {
        return new GridData(200, 28);
    }
}

