/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.widgets.fileuploadkit;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.rap.rwt.internal.widgets.IFileUploadAdapter;
import org.eclipse.rap.rwt.widgets.FileUpload;
import org.eclipse.swt.widgets.Event;

public class FileUploadOperationHandler
extends ControlOperationHandler<FileUpload> {
    private static final String PROP_FILE_NAMES = "fileNames";

    public FileUploadOperationHandler(FileUpload fileUpload) {
        super(fileUpload);
    }

    @Override
    public void handleSet(FileUpload fileUpload, JsonObject properties) {
        super.handleSet(fileUpload, properties);
        this.handleSetFileNames(fileUpload, properties);
    }

    @Override
    public void handleNotify(FileUpload fileUpload, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(fileUpload, properties);
        } else {
            super.handleNotify(fileUpload, eventName, properties);
        }
    }

    public void handleSetFileNames(FileUpload fileUpload, JsonObject properties) {
        JsonValue value = properties.get(PROP_FILE_NAMES);
        if (value != null) {
            JsonArray arrayValue = value.asArray();
            String[] fileNames = new String[arrayValue.size()];
            int i = 0;
            while (i < fileNames.length) {
                fileNames[i] = arrayValue.get(i).asString();
                ++i;
            }
            fileUpload.getAdapter(IFileUploadAdapter.class).setFileNames(fileNames);
        }
    }

    public void handleNotifySelection(FileUpload fileUpload, JsonObject properties) {
        Event event = FileUploadOperationHandler.createSelectionEvent(13, properties);
        fileUpload.notifyListeners(13, event);
    }
}

