/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.pages.internal.scripting.CustomBehaviors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ValidationExamplePage
implements IExamplePage {
    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)2));
        this.createLeftInputForm(parent);
        this.createRightInputForm(parent);
    }

    private void createLeftInputForm(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)ExampleUtil.createFillData());
        composite.setLayout((Layout)ExampleUtil.createGridLayoutWithoutMargin((int)1, (boolean)false));
        this.createDigitsOnlyExample(composite);
        this.createUpperCaseExample(composite);
    }

    private void createRightInputForm(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)ExampleUtil.createFillData());
        composite.setLayout((Layout)ExampleUtil.createGridLayoutWithoutMargin((int)1, (boolean)false));
        this.createDateExample(composite);
        this.createEMailExample(composite);
    }

    private void createDigitsOnlyExample(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)false));
        composite.setLayoutData((Object)new GridData(768));
        ExampleUtil.createHeading((Composite)composite, (String)"Digits-only field", (int)1);
        this.createDigitsOnlyServerExample(composite);
        this.createDigitsOnlyClientExample(composite);
        this.createDigitsOnlyClientEnforcementExample(composite);
    }

    private void createDigitsOnlyServerExample(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Validation on the server (with latency):");
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setText("23");
        text.setSelection(2);
        text.setFocus();
        text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String regexp;
                Text widget = (Text)event.widget;
                String text = widget.getText();
                if (!text.matches(regexp = "^[0-9]*$")) {
                    widget.setBackground(new Color((Device)widget.getDisplay(), 255, 255, 128));
                    widget.setToolTipText("Only digits allowed!");
                } else {
                    widget.setBackground(null);
                    widget.setToolTipText(null);
                }
            }
        });
    }

    private void createDigitsOnlyClientExample(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Validation on the client (immediate):");
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setText("23");
        text.setSelection(2);
        CustomBehaviors.addDigitsOnlyBehavior(text);
    }

    private void createDigitsOnlyClientEnforcementExample(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Enforcement on the client:");
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setText("23");
        text.setSelection(2);
        CustomBehaviors.addDigitsOnlyEnforcementBehavior(text);
    }

    private void createUpperCaseExample(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)false));
        composite.setLayoutData((Object)new GridData(768));
        ExampleUtil.createHeading((Composite)composite, (String)"Auto upper-case field", (int)1);
        Label label = new Label(composite, 0);
        label.setText("Turns all characters to upper-case while typing:");
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        CustomBehaviors.addUpperCaseBehavior(text);
    }

    private void createDateExample(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)false));
        composite.setLayoutData((Object)new GridData(768));
        ExampleUtil.createHeading((Composite)composite, (String)"Valid date", (int)1);
        Label label = new Label(composite, 0);
        label.setText("Basic check on the client, server-side validation on focus-out:");
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        CustomBehaviors.addDateFieldBehavior(text);
    }

    private void createEMailExample(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)false));
        composite.setLayoutData((Object)new GridData(768));
        ExampleUtil.createHeading((Composite)composite, (String)"Valid email address", (int)1);
        Label label = new Label(composite, 0);
        label.setText("Basic client-side Modify check,\n server-side validation on focus-out:");
        Text text = new Text(composite, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        CustomBehaviors.addEMailBehavior(text);
    }
}

