/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;

public class LocalConnector
extends AbstractConnector {
    private final BlockingQueue<LocalEndPoint> _connects = new LinkedBlockingQueue<LocalEndPoint>();

    public LocalConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, int acceptors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, bufferPool, Math.max(1, acceptors), factories);
        this.setIdleTimeout(30000L);
    }

    public LocalConnector(Server server) {
        this(server, null, null, null, -1, new HttpConnectionFactory());
    }

    public LocalConnector(Server server, SslContextFactory.Server sslContextFactory) {
        this(server, null, null, null, -1, AbstractConnectionFactory.getFactories(sslContextFactory, new HttpConnectionFactory()));
    }

    public LocalConnector(Server server, ConnectionFactory connectionFactory) {
        this(server, null, null, null, -1, connectionFactory);
    }

    public LocalConnector(Server server, ConnectionFactory connectionFactory, SslContextFactory.Server sslContextFactory) {
        this(server, null, null, null, -1, AbstractConnectionFactory.getFactories(sslContextFactory, connectionFactory));
    }

    @Override
    public Object getTransport() {
        return this;
    }

    public LocalEndPoint executeRequest(String rawRequest) {
        return this.executeRequest(BufferUtil.toBuffer((String)rawRequest, (Charset)StandardCharsets.UTF_8));
    }

    private LocalEndPoint executeRequest(ByteBuffer rawRequest) {
        if (!this.isStarted()) {
            throw new IllegalStateException("!STARTED");
        }
        if (this.isShutdown()) {
            throw new IllegalStateException("Shutdown");
        }
        LocalEndPoint endp = new LocalEndPoint();
        endp.addInput(rawRequest);
        this._connects.add(endp);
        return endp;
    }

    public LocalEndPoint connect() {
        LocalEndPoint endp = new LocalEndPoint();
        this._connects.add(endp);
        return endp;
    }

    @Override
    protected void accept(int acceptorID) throws InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("accepting {}", (Object)acceptorID);
        }
        LocalEndPoint endPoint = this._connects.take();
        Connection connection = this.getDefaultConnectionFactory().newConnection(this, (EndPoint)endPoint);
        endPoint.setConnection(connection);
        endPoint.onOpen();
        this.onEndPointOpened((EndPoint)endPoint);
        connection.onOpen();
    }

    public ByteBuffer getResponse(ByteBuffer requestsBuffer) throws Exception {
        return this.getResponse(requestsBuffer, false, 10L, TimeUnit.SECONDS);
    }

    public ByteBuffer getResponse(ByteBuffer requestBuffer, long time, TimeUnit unit) throws Exception {
        boolean head = BufferUtil.toString((ByteBuffer)requestBuffer).toLowerCase().startsWith("head ");
        if (LOG.isDebugEnabled()) {
            LOG.debug("requests {}", (Object)BufferUtil.toUTF8String((ByteBuffer)requestBuffer));
        }
        LocalEndPoint endp = this.executeRequest(requestBuffer);
        return endp.waitForResponse(head, time, unit);
    }

    public ByteBuffer getResponse(ByteBuffer requestBuffer, boolean head, long time, TimeUnit unit) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("requests {}", (Object)BufferUtil.toUTF8String((ByteBuffer)requestBuffer));
        }
        LocalEndPoint endp = this.executeRequest(requestBuffer);
        return endp.waitForResponse(head, time, unit);
    }

    public String getResponse(String rawRequest) throws Exception {
        return this.getResponse(rawRequest, false, 30L, TimeUnit.SECONDS);
    }

    public String getResponse(String rawRequest, long time, TimeUnit unit) throws Exception {
        boolean head = rawRequest.toLowerCase().startsWith("head ");
        ByteBuffer requestsBuffer = BufferUtil.toBuffer((String)rawRequest, (Charset)StandardCharsets.ISO_8859_1);
        if (LOG.isDebugEnabled()) {
            LOG.debug("request {}", (Object)BufferUtil.toUTF8String((ByteBuffer)requestsBuffer));
        }
        LocalEndPoint endp = this.executeRequest(requestsBuffer);
        return BufferUtil.toString((ByteBuffer)endp.waitForResponse(head, time, unit), (Charset)StandardCharsets.ISO_8859_1);
    }

    public String getResponse(String rawRequest, boolean head, long time, TimeUnit unit) throws Exception {
        ByteBuffer requestsBuffer = BufferUtil.toBuffer((String)rawRequest, (Charset)StandardCharsets.ISO_8859_1);
        if (LOG.isDebugEnabled()) {
            LOG.debug("request {}", (Object)BufferUtil.toUTF8String((ByteBuffer)requestsBuffer));
        }
        LocalEndPoint endp = this.executeRequest(requestsBuffer);
        return BufferUtil.toString((ByteBuffer)endp.waitForResponse(head, time, unit), (Charset)StandardCharsets.ISO_8859_1);
    }

    public class LocalEndPoint
    extends ByteArrayEndPoint {
        private final CountDownLatch _closed;
        private ByteBuffer _responseData;

        public LocalEndPoint() {
            super(LocalConnector.this.getScheduler(), LocalConnector.this.getIdleTimeout());
            this._closed = new CountDownLatch(1);
            this.setGrowOutput(true);
        }

        protected void execute(Runnable task) {
            LocalConnector.this.getExecutor().execute(task);
        }

        public void onClose(Throwable cause) {
            Connection connection = this.getConnection();
            if (connection != null) {
                connection.onClose(cause);
            }
            LocalConnector.this.onEndPointClosed((EndPoint)this);
            super.onClose(cause);
            this._closed.countDown();
        }

        public void doShutdownOutput() {
            super.shutdownOutput();
            this.close();
        }

        public void waitUntilClosed() {
            while (this.isOpen()) {
                try {
                    if (this._closed.await(10L, TimeUnit.SECONDS)) continue;
                    break;
                }
                catch (Exception e) {
                    AbstractConnector.LOG.warn("Close wait failed", (Throwable)e);
                }
            }
        }

        public void waitUntilClosedOrIdleFor(long idleFor, TimeUnit units) {
            Thread.yield();
            int size = this.getOutput().remaining();
            while (this.isOpen()) {
                try {
                    if (this._closed.await(idleFor, units)) continue;
                    if (size == this.getOutput().remaining()) {
                        if (AbstractConnector.LOG.isDebugEnabled()) {
                            AbstractConnector.LOG.debug("idle for {} {}", (Object)idleFor, (Object)units);
                        }
                        return;
                    }
                    size = this.getOutput().remaining();
                }
                catch (Exception e) {
                    AbstractConnector.LOG.warn("Close wait failed", (Throwable)e);
                }
            }
        }

        public ByteBuffer getResponseData() {
            return this._responseData;
        }

        public String getResponse() throws Exception {
            return this.getResponse(false, 30L, TimeUnit.SECONDS);
        }

        public String getResponse(boolean head, long time, TimeUnit unit) throws Exception {
            ByteBuffer response = this.waitForResponse(head, time, unit);
            if (response != null) {
                return BufferUtil.toString((ByteBuffer)response);
            }
            return null;
        }

        public ByteBuffer waitForResponse(boolean head, long time, TimeUnit unit) throws Exception {
            return this.waitForResponse(head, time, unit, i -> {});
        }

        /*
         * Unable to fully structure code
         */
        public ByteBuffer waitForResponse(boolean head, long time, TimeUnit unit, final Consumer<Integer> statusConsumer) throws Exception {
            handler = new HttpParser.ResponseHandler(){
                final /* synthetic */ LocalEndPoint this$1;
                {
                    this.this$1 = this$1;
                }

                public void parsedHeader(HttpField field) {
                }

                public boolean contentComplete() {
                    return false;
                }

                public boolean messageComplete() {
                    return true;
                }

                public boolean headerComplete() {
                    return false;
                }

                public void earlyEOF() {
                }

                public boolean content(ByteBuffer item) {
                    return false;
                }

                public void startResponse(HttpVersion version, int status, String reason) {
                    statusConsumer.accept(status);
                }
            };
            parser = new HttpParser(handler);
            parser.setHeadResponse(head);
            bout = new ByteArrayOutputStream2();
            try {
                block17: {
                    block8: while (true) {
                        if (BufferUtil.hasContent((ByteBuffer)this._responseData)) {
                            chunk = this._responseData;
                        } else {
                            chunk = this.waitForOutput(time, unit);
                            if (BufferUtil.isEmpty((ByteBuffer)chunk)) {
                                if (!this.isOpen() || this.isOutputShutdown() || LocalConnector.this.isShutdown()) {
                                    parser.atEOF();
                                    parser.parseNext(BufferUtil.EMPTY_BUFFER);
                                    break block17;
                                }
                                var10_11 = null;
                                return var10_11;
                            }
                        }
                        do {
                            if (!BufferUtil.hasContent((ByteBuffer)chunk)) continue block8;
                            pos = chunk.position();
                            complete = parser.parseNext(chunk);
                            if (chunk.position() == pos) {
                                if (!BufferUtil.isEmpty((ByteBuffer)chunk)) ** break;
                                continue block8;
                                var12_14 = null;
                                return var12_14;
                            }
                            bout.write(chunk.array(), chunk.arrayOffset() + pos, chunk.position() - pos);
                        } while (!complete);
                        break;
                    }
                    if (BufferUtil.hasContent((ByteBuffer)chunk)) {
                        this._responseData = chunk;
                    }
                }
                if (bout.getCount() == 0 && this.isOutputShutdown()) {
                    var9_8 = null;
                    return var9_8;
                }
                var9_8 = ByteBuffer.wrap(bout.getBuf(), 0, bout.getCount());
                return var9_8;
            }
            finally {
                bout.close();
            }
        }
    }
}

