/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture.internal;

import java.io.File;

public class FileUtil {
    public static File createTempDir() {
        String subDirName;
        File globalTmpDir = new File(System.getProperty("java.io.tmpdir"));
        File tmpDir = new File(globalTmpDir, subDirName = "rap-test-" + Long.toHexString(System.currentTimeMillis()));
        if (!tmpDir.mkdir()) {
            String message = "Failed to create temp directory: " + tmpDir.getAbsolutePath();
            throw new IllegalStateException(message);
        }
        return tmpDir;
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            FileUtil.deleteChildren(file);
        }
        FileUtil.deleteFile(file);
    }

    private static void deleteChildren(File file) {
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            FileUtil.delete(child);
            ++n2;
        }
    }

    private static void deleteFile(File file) {
        if (!file.delete() && file.exists()) {
            throw new IllegalStateException("Could not delete: " + file.getPath());
        }
    }

    private FileUtil() {
    }
}

