/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext.toolbar;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Deprecated
public class ToolbarConfiguration {
    private static final String CKEDITOR_CONFIG_TOOLBAR_GROUPS = "CKEDITOR.config.toolbarGroups";
    private static final String CKEDITOR_CONFIG_REMOVE_BUTTONS = "CKEDITOR.config.removeButtons";
    public boolean removePasteText = true;
    public boolean removePasteFromWord = true;
    public boolean removeStyles = true;
    public boolean removeFormat = true;
    public boolean toolbarCollapsible = false;
    public boolean toolbarInitialExpanded = true;
    private final Set<String> removedButtons = new HashSet<String>();

    protected String getToolbarGroupConfiguration() {
        StringBuilder builder = new StringBuilder(CKEDITOR_CONFIG_TOOLBAR_GROUPS);
        builder.append(" = [");
        builder.append("{\"name\":\"basicstyles\",\"groups\":[\"basicstyles\",\"cleanup\"]},");
        builder.append("{\"name\":\"paragraph\",\"groups\":[\"list\",\"indent\",\"align\"]},");
        builder.append("\"/\",");
        builder.append("{\"name\":\"styles\"},");
        builder.append("{\"name\":\"colors\" }");
        builder.append("];");
        return builder.toString();
    }

    protected String getRemoveButtonConfiguration() {
        StringBuilder builder = new StringBuilder(CKEDITOR_CONFIG_REMOVE_BUTTONS);
        builder.append(" = \"");
        if (this.removePasteText) {
            builder.append("PasteText");
        }
        if (this.removePasteFromWord) {
            builder.append(",PasteFromWord");
        }
        if (this.removeStyles) {
            builder.append(",Styles");
        }
        if (this.removeFormat) {
            builder.append(",Format");
        }
        for (String removed : this.removedButtons) {
            builder.append(",").append(removed);
        }
        builder.append("\";");
        return builder.toString();
    }

    public void addDefaultToolbarButton(String buttonName) {
        this.removedButtons.remove(buttonName);
    }

    public void removeDefaultToolbarButton(String buttonName) {
        this.removedButtons.add(buttonName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append("\"toolbarGroups\":").append(this.getExtractedToolbarGroupConfiguration()).append(",");
        builder.append("\"removeButtons\":").append(this.getExtractedRemoveButtonConfiguration()).append(",");
        builder.append("\"toolbarCanCollapse\":").append(this.toolbarCollapsible).append(",");
        builder.append("\"toolbarStartupExpanded\":").append(this.toolbarInitialExpanded);
        builder.append("}");
        return builder.toString();
    }

    private String getExtractedToolbarGroupConfiguration() {
        String toolbarGroupConfiguration = this.getToolbarGroupConfiguration().trim();
        if (!toolbarGroupConfiguration.startsWith(CKEDITOR_CONFIG_TOOLBAR_GROUPS) || !toolbarGroupConfiguration.endsWith(";")) {
            throw new RuntimeException("Invalid CKEditor toolbarGroups configuration");
        }
        int equalSignIndex = toolbarGroupConfiguration.indexOf(61);
        int lastSemicolonIndex = toolbarGroupConfiguration.lastIndexOf(59);
        return toolbarGroupConfiguration.substring(equalSignIndex + 1, lastSemicolonIndex).trim();
    }

    private String getExtractedRemoveButtonConfiguration() {
        String removeButtonConfiguration = this.getRemoveButtonConfiguration().trim();
        if (!removeButtonConfiguration.startsWith(CKEDITOR_CONFIG_REMOVE_BUTTONS) || !removeButtonConfiguration.endsWith(";")) {
            throw new RuntimeException("Invalid CKEditor removeButtons configuration");
        }
        int equalSignIndex = removeButtonConfiguration.indexOf(61);
        int lastSemicolonIndex = removeButtonConfiguration.lastIndexOf(59);
        return removeButtonConfiguration.substring(equalSignIndex + 1, lastSemicolonIndex).trim();
    }

    public String[] getToolbarButtonConfigurations() {
        return new String[]{this.getToolbarGroupConfiguration(), this.getRemoveButtonConfiguration()};
    }

    public Set<String> getRemovedButtons() {
        return Collections.unmodifiableSet(this.removedButtons);
    }
}

