/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt;

import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.SingletonManager;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.UISession;

public final class SingletonUtil {
    public static <T> T getSessionInstance(Class<T> type) {
        return SingletonUtil.getUniqueInstance(type, RWT.getUISession());
    }

    public static <T> T getUniqueInstance(Class<T> type, UISession uiSession) {
        ParamCheck.notNull(type, "type");
        ParamCheck.notNull(uiSession, "uiSession");
        return SingletonManager.getInstance(uiSession).getSingleton(type);
    }

    public static <T> T getUniqueInstance(Class<T> type, ApplicationContext applicationContext) {
        ParamCheck.notNull(type, "type");
        ParamCheck.notNull(applicationContext, "applicationContext");
        return SingletonManager.getInstance(applicationContext).getSingleton(type);
    }
}

