/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceContext;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.internal.util.ClassUtil;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

public final class ContextUtil {
    private static final ClassLoader CLASS_LOADER = ContextUtil.class.getClassLoader();
    private static final HttpServletResponse FAKE_RESPONSE = ContextUtil.createFakeResponse();
    private static final Class<?> FAKE_REQUEST_CLASS = ContextUtil.getRequestProxyClass();

    private ContextUtil() {
    }

    public static void runNonUIThreadWithFakeContext(Display display, Runnable runnable) {
        UISession uiSession = display.getAdapter(IDisplayAdapter.class).getUISession();
        ContextUtil.runNonUIThreadWithFakeContext(uiSession, runnable);
    }

    public static void runNonUIThreadWithFakeContext(UISession uiSession, Runnable runnable) {
        boolean useFakeContext;
        boolean useDifferentContext = ContextProvider.hasContext() && ContextProvider.getUISession() != uiSession;
        ServiceContext contextBuffer = null;
        boolean wasMapped = false;
        if (useDifferentContext) {
            contextBuffer = ContextProvider.getContext();
            wasMapped = ContextProvider.releaseContextHolder();
        }
        boolean bl = useFakeContext = !ContextProvider.hasContext();
        if (useFakeContext) {
            ContextProvider.setContext(ContextUtil.createFakeContext(uiSession));
        }
        try {
            runnable.run();
        }
        finally {
            if (useFakeContext) {
                ContextProvider.disposeContext();
            }
            if (useDifferentContext) {
                if (wasMapped) {
                    ContextProvider.setContext(contextBuffer, Thread.currentThread());
                } else {
                    ContextProvider.setContext(contextBuffer);
                }
            }
        }
    }

    public static ServiceContext createFakeContext(UISession uiSession) {
        HttpServletRequest request = ContextUtil.createFakeRequest(uiSession);
        ServiceContext result = new ServiceContext(request, FAKE_RESPONSE, uiSession);
        result.setServiceStore(new ServiceStore());
        return result;
    }

    private static HttpServletRequest createFakeRequest(UISession uiSession) {
        RequestInvocationHandler invocationHandler = new RequestInvocationHandler(uiSession);
        Class[] paramTypes = new Class[]{InvocationHandler.class};
        Object[] paramValues = new Object[]{invocationHandler};
        Object fakeRequest = ClassUtil.newInstance(FAKE_REQUEST_CLASS, paramTypes, paramValues);
        return (HttpServletRequest)fakeRequest;
    }

    private static Class<?> getRequestProxyClass() {
        return Proxy.getProxyClass(CLASS_LOADER, HttpServletRequest.class);
    }

    private static HttpServletResponse createFakeResponse() {
        Class[] interfaces = new Class[]{HttpServletResponse.class};
        ResponseInvocationHandler invocationHandler = new ResponseInvocationHandler();
        Object proxy = Proxy.newProxyInstance(CLASS_LOADER, interfaces, (InvocationHandler)invocationHandler);
        return (HttpServletResponse)proxy;
    }

    private static class RequestInvocationHandler
    implements InvocationHandler {
        private final UISession uiSession;

        RequestInvocationHandler(UISession uiSession) {
            this.uiSession = uiSession;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            HttpSession result;
            if ("getSession".equals(method.getName())) {
                result = this.uiSession.getHttpSession();
            } else if ("getLocale".equals(method.getName())) {
                result = null;
            } else {
                throw new UnsupportedOperationException();
            }
            return result;
        }
    }

    private static final class ResponseInvocationHandler
    implements InvocationHandler {
        private ResponseInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new UnsupportedOperationException();
        }
    }
}

