/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.expanditemkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IExpandBarAdapter;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.expanditemkit.ExpandItemOperationHandler;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public final class ExpandItemLCA
extends WidgetLCA<ExpandItem> {
    public static final ExpandItemLCA INSTANCE = new ExpandItemLCA();
    private static final String TYPE = "rwt.widgets.ExpandItem";
    private static final String PROP_EXPANDED = "expanded";
    private static final String PROP_HEADER_HEIGHT = "headerHeight";
    private static final int DEFAULT_HEADER_HEIGHT = 24;

    @Override
    public void preserveValues(ExpandItem item) {
        WidgetLCAUtil.preserveBounds(item, ExpandItemLCA.getBounds(item));
        ItemLCAUtil.preserve(item);
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_EXPANDED, item.getExpanded());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_HEADER_HEIGHT, item.getHeaderHeight());
    }

    @Override
    public void renderInitialization(ExpandItem item) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(item, TYPE);
        remoteObject.setHandler(new ExpandItemOperationHandler(item));
        remoteObject.set("parent", WidgetUtil.getId(item.getParent()));
    }

    @Override
    public void renderChanges(ExpandItem item) throws IOException {
        WidgetLCAUtil.renderCustomVariant(item);
        WidgetLCAUtil.renderBounds(item, ExpandItemLCA.getBounds(item));
        ItemLCAUtil.renderChanges(item);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_EXPANDED, item.getExpanded(), false);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_HEADER_HEIGHT, item.getHeaderHeight(), 24);
    }

    private static Rectangle getBounds(ExpandItem item) {
        return ExpandItemLCA.getExpandBarAdapter(item).getBounds(item);
    }

    private static IExpandBarAdapter getExpandBarAdapter(ExpandItem item) {
        return item.getParent().getAdapter(IExpandBarAdapter.class);
    }

    private ExpandItemLCA() {
    }
}

