/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.preferences.internal;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rap.e4.preferences.EPreference;
import org.eclipse.rap.e4.preferences.EPreferenceListener;
import org.eclipse.rap.e4.preferences.EPreferenceService;
import org.eclipse.rap.rwt.service.SettingStore;
import org.eclipse.rap.rwt.service.SettingStoreEvent;
import org.eclipse.rap.rwt.service.SettingStoreListener;

public class RAPPreferenceService
implements EPreferenceService {
    private final SettingStore settingStore;
    private Map<PreferenceImpl, Boolean> trackedPreferences = Collections.synchronizedMap(new WeakHashMap());
    private final SettingStoreListener listener;

    @Inject
    public RAPPreferenceService(SettingStore settingStore) {
        this.settingStore = settingStore;
        this.listener = new SettingStoreListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void settingChanged(SettingStoreEvent event) {
                if (event.getAttributeName().contains("#")) {
                    String nodePath = event.getAttributeName().substring(0, event.getAttributeName().indexOf(35));
                    PreferenceImpl[] array = new PreferenceImpl[RAPPreferenceService.this.trackedPreferences.size()];
                    Map<PreferenceImpl, Boolean> map = RAPPreferenceService.this.trackedPreferences;
                    synchronized (map) {
                        Iterator<Map.Entry<PreferenceImpl, Boolean>> iterator = RAPPreferenceService.this.trackedPreferences.entrySet().iterator();
                        int index = 0;
                        while (iterator.hasNext()) {
                            Map.Entry<PreferenceImpl, Boolean> entry = iterator.next();
                            if (entry.getKey() == null) {
                                iterator.remove();
                                continue;
                            }
                            if (!entry.getKey().nodePath.equals(nodePath)) continue;
                            array[index++] = entry.getKey();
                        }
                    }
                    int i = 0;
                    while (i < array.length) {
                        if (array[i] == null) break;
                        array[i].fireChange();
                        ++i;
                    }
                }
            }
        };
        this.settingStore.addSettingStoreListener(this.listener);
    }

    public void track(PreferenceImpl impl) {
        this.trackedPreferences.put(impl, Boolean.TRUE);
    }

    public void untrack(PreferenceImpl impl) {
        this.trackedPreferences.remove(impl);
    }

    @Override
    public boolean getBoolean(String nodePath, String key, boolean defaultValue) {
        String v = this.settingStore.getAttribute(RAPPreferenceService.getAttributeName(nodePath, key));
        if (v == null) {
            return defaultValue;
        }
        return Boolean.valueOf(v);
    }

    @Override
    public int getInt(String nodePath, String key, int defaultValue) {
        String v = this.settingStore.getAttribute(RAPPreferenceService.getAttributeName(nodePath, key));
        if (v == null) {
            return defaultValue;
        }
        return Integer.parseInt(v);
    }

    @Override
    public double getDouble(String nodePath, String key, double defaultValue) {
        String v = this.settingStore.getAttribute(RAPPreferenceService.getAttributeName(nodePath, key));
        if (v == null) {
            return defaultValue;
        }
        return Double.parseDouble(v);
    }

    @Override
    public float getFloat(String nodePath, String key, float defaultValue) {
        String v = this.settingStore.getAttribute(RAPPreferenceService.getAttributeName(nodePath, key));
        if (v == null) {
            return defaultValue;
        }
        return Float.parseFloat(v);
    }

    @Override
    public long getLong(String nodePath, String key, long defaultValue) {
        String v = this.settingStore.getAttribute(RAPPreferenceService.getAttributeName(nodePath, key));
        if (v == null) {
            return defaultValue;
        }
        return Long.parseLong(v);
    }

    @Override
    public String getString(String nodePath, String key) {
        return this.settingStore.getAttribute(RAPPreferenceService.getAttributeName(nodePath, key));
    }

    @Override
    public EPreference getNode(String nodePath) {
        return new PreferenceImpl(nodePath);
    }

    @Override
    public IStatus setBoolean(String nodePath, String key, boolean value) {
        return this.setString(nodePath, key, String.valueOf(value));
    }

    @Override
    public IStatus setDouble(String nodePath, String key, double value) {
        return this.setString(nodePath, key, String.valueOf(value));
    }

    @Override
    public IStatus setFloat(String nodePath, String key, float value) {
        return this.setString(nodePath, key, String.valueOf(value));
    }

    @Override
    public IStatus setInt(String nodePath, String key, int value) {
        return this.setString(nodePath, key, String.valueOf(value));
    }

    @Override
    public IStatus setLong(String nodePath, String key, long value) {
        return this.setString(nodePath, key, String.valueOf(value));
    }

    @Override
    public IStatus setString(String nodePath, String key, String value) {
        try {
            this.settingStore.setAttribute(RAPPreferenceService.getAttributeName(nodePath, key), value);
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.rap.e4", "Unable to store preference", (Throwable)e);
        }
    }

    static String getAttributeName(String nodePath, String key) {
        return String.valueOf(nodePath) + "#" + key;
    }

    class PreferenceImpl
    implements EPreference {
        private String nodePath;
        private List<EPreferenceListener> listenerList = new ArrayList<EPreferenceListener>();

        public PreferenceImpl(String nodePath) {
            this.nodePath = nodePath;
        }

        @Override
        public boolean getBoolean(String key, boolean defaultValue) {
            return RAPPreferenceService.this.getBoolean(this.nodePath, key, defaultValue);
        }

        @Override
        public int getInt(String key, int defaultValue) {
            return RAPPreferenceService.this.getInt(this.nodePath, key, defaultValue);
        }

        @Override
        public double getDouble(String key, double defaultValue) {
            return RAPPreferenceService.this.getDouble(this.nodePath, key, defaultValue);
        }

        @Override
        public float getFloat(String key, float defaultValue) {
            return RAPPreferenceService.this.getFloat(this.nodePath, key, defaultValue);
        }

        @Override
        public long getLong(String key, long defaultValue) {
            return RAPPreferenceService.this.getLong(this.nodePath, key, defaultValue);
        }

        @Override
        public String getString(String key) {
            return RAPPreferenceService.this.getString(this.nodePath, key);
        }

        @Override
        public IStatus setBoolean(String key, boolean value) {
            return RAPPreferenceService.this.setBoolean(this.nodePath, key, value);
        }

        @Override
        public IStatus setDouble(String key, double value) {
            return RAPPreferenceService.this.setDouble(this.nodePath, key, value);
        }

        @Override
        public IStatus setFloat(String key, float value) {
            return RAPPreferenceService.this.setFloat(this.nodePath, key, value);
        }

        @Override
        public IStatus setInt(String key, int value) {
            return RAPPreferenceService.this.setInt(this.nodePath, key, value);
        }

        @Override
        public IStatus setLong(String key, long value) {
            return RAPPreferenceService.this.setLong(this.nodePath, key, value);
        }

        @Override
        public IStatus setString(String key, String value) {
            return RAPPreferenceService.this.setString(this.nodePath, key, value);
        }

        @Override
        public void addChangeListener(EPreferenceListener listener) {
            this.listenerList.add(listener);
            if (this.listenerList.size() == 1) {
                RAPPreferenceService.this.track(this);
            }
        }

        @Override
        public void removeChangeListener(EPreferenceListener listener) {
            this.listenerList.remove(listener);
            if (this.listenerList.isEmpty()) {
                RAPPreferenceService.this.untrack(this);
            }
        }

        public void fireChange() {
            if (!this.listenerList.isEmpty()) {
                EPreferenceListener[] listeners = this.listenerList.toArray(new EPreferenceListener[this.listenerList.size()]);
                int i = 0;
                while (i < listeners.length) {
                    listeners[i].preferenceChange();
                    ++i;
                }
            }
        }
    }
}

