/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;

public class CheatSheetStopWatch {
    private static CheatSheetStopWatch stopWatch = null;
    private Map table;

    private CheatSheetStopWatch() {
    }

    public static CheatSheetStopWatch getInstance() {
        if (stopWatch == null) {
            stopWatch = new CheatSheetStopWatch();
        }
        return stopWatch;
    }

    public void start(String key) {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            entry = new Entry();
            this.putEntry(key, entry);
        } else {
            this.resetEntry(entry);
        }
        entry.start = System.currentTimeMillis();
    }

    public void stop(String key) {
        Entry entry = this.getEntry(key);
        entry.stop = System.currentTimeMillis();
    }

    public long totalElapsedTime(String key) {
        Entry entry = this.getEntry(key);
        return entry.stop - entry.start;
    }

    public void lapTime(String key) {
        Entry entry = this.getEntry(key);
        entry.previousLap = entry.currentLap == -1L ? entry.start : entry.currentLap;
        entry.currentLap = System.currentTimeMillis();
    }

    public long elapsedTime(String key) {
        Entry entry = this.getEntry(key);
        return entry.currentLap - entry.previousLap;
    }

    private Entry getEntry(String key) {
        return (Entry)this.getTable().get(key);
    }

    private void putEntry(String key, Entry entry) {
        this.getTable().put(key, entry);
    }

    private void resetEntry(Entry entry) {
        entry.start = -1L;
        entry.stop = -1L;
        entry.currentLap = -1L;
        entry.previousLap = -1L;
    }

    private Map getTable() {
        if (this.table == null) {
            this.table = new HashMap(10);
        }
        return this.table;
    }

    public static boolean isTracing() {
        String traceTimes;
        return CheatSheetPlugin.getPlugin().isDebugging() && (traceTimes = Platform.getDebugOption((String)"org.eclipse.ui.cheatsheets/trace/creation/times")) != null && traceTimes.equalsIgnoreCase("true");
    }

    public static void startStopWatch(String key) {
        if (CheatSheetStopWatch.isTracing()) {
            CheatSheetStopWatch.getInstance().start(key);
        }
    }

    public static void printTotalTime(String key, String message) {
        if (CheatSheetStopWatch.isTracing()) {
            CheatSheetStopWatch.getInstance().stop(key);
            System.out.print(message);
            System.out.println(CheatSheetStopWatch.getInstance().totalElapsedTime(key));
        }
    }

    public static void printLapTime(String key, String message) {
        if (CheatSheetStopWatch.isTracing()) {
            CheatSheetStopWatch.getInstance().lapTime(key);
            System.out.print(message);
            System.out.println(CheatSheetStopWatch.getInstance().elapsedTime(key));
        }
    }

    private static class Entry {
        protected long start = -1L;
        protected long stop = -1L;
        protected long currentLap = -1L;
        protected long previousLap = -1L;

        private Entry() {
        }
    }
}

