/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ComponentRegistryKey;
import org.apache.felix.scr.impl.helper.ConfigAdminTracker;
import org.apache.felix.scr.impl.logger.BundleLogger;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.logger.ScrLogger;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.ComponentHolder;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.manager.ExtendedServiceEvent;
import org.apache.felix.scr.impl.manager.ExtendedServiceListener;
import org.apache.felix.scr.impl.manager.RegionConfigurationSupport;
import org.apache.felix.scr.impl.manager.ScrConfiguration;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.xml.XmlHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentException;
import org.xml.sax.helpers.DefaultHandler;

public class BundleComponentActivator
implements ComponentActivator {
    private final ComponentRegistry m_componentRegistry;
    private final Bundle m_bundle;
    private final BundleContext m_context;
    private final List<ComponentHolder<?>> m_holders = new ArrayList();
    private final ComponentActorThread m_componentActor;
    private final AtomicBoolean m_active = new AtomicBoolean(true);
    private final CountDownLatch m_closeLatch = new CountDownLatch(1);
    private final ScrConfiguration m_configuration;
    private final ConfigAdminTracker configAdminTracker;
    private final Map<String, ListenerInfo> listenerMap = new HashMap<String, ListenerInfo>();
    private final BundleLogger logger;
    private final ServiceReference<?> m_trueCondition;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(String serviceFilterString, ExtendedServiceListener<ExtendedServiceEvent> listener) {
        Map<String, ListenerInfo> map = this.listenerMap;
        synchronized (map) {
            this.logger.log(InternalLogger.Level.DEBUG, "serviceFilterString: " + serviceFilterString, null);
            ListenerInfo listenerInfo = this.listenerMap.get(serviceFilterString);
            if (listenerInfo == null) {
                listenerInfo = new ListenerInfo();
                this.listenerMap.put(serviceFilterString, listenerInfo);
                try {
                    this.m_context.addServiceListener((ServiceListener)listenerInfo, serviceFilterString);
                }
                catch (InvalidSyntaxException e) {
                    throw (IllegalArgumentException)new IllegalArgumentException("invalid class name filter").initCause(e);
                }
            }
            listenerInfo.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(String serviceFilterString, ExtendedServiceListener<ExtendedServiceEvent> listener) {
        Map<String, ListenerInfo> map = this.listenerMap;
        synchronized (map) {
            ListenerInfo listenerInfo = this.listenerMap.get(serviceFilterString);
            if (listenerInfo != null && listenerInfo.remove(listener)) {
                this.listenerMap.remove(serviceFilterString);
                this.m_context.removeServiceListener((ServiceListener)listenerInfo);
            }
        }
    }

    public BundleComponentActivator(ScrLogger scrLogger, ComponentRegistry componentRegistry, ComponentActorThread componentActor, BundleContext context, ScrConfiguration configuration, List<ComponentMetadata> cachedComponentMetadata, ServiceReference<?> trueConditiion) throws ComponentException {
        this.logger = scrLogger.bundle(context.getBundle());
        this.m_componentRegistry = componentRegistry;
        this.m_componentActor = componentActor;
        this.m_context = context;
        this.m_bundle = context.getBundle();
        this.m_configuration = configuration;
        this.m_trueCondition = trueConditiion;
        this.logger.log(InternalLogger.Level.DEBUG, "BundleComponentActivator : Bundle active", null);
        this.initialize(cachedComponentMetadata);
        ConfigAdminTracker tracker = null;
        for (ComponentHolder<?> holder : this.m_holders) {
            if (holder.getComponentMetadata().isConfigurationIgnored()) continue;
            tracker = new ConfigAdminTracker(this);
            break;
        }
        this.configAdminTracker = tracker;
    }

    protected void initialize(List<ComponentMetadata> cachedComponentMetadata) {
        if (cachedComponentMetadata != null) {
            for (ComponentMetadata metadata : cachedComponentMetadata) {
                this.validateAndRegister(metadata);
            }
        } else {
            String descriptorLocations = (String)this.m_bundle.getHeaders("").get("Service-Component");
            if (descriptorLocations == null) {
                throw new ComponentException("Service-Component entry not found in the manifest");
            }
            this.logger.log(InternalLogger.Level.DEBUG, "BundleComponentActivator : Descriptor locations {0}", null, descriptorLocations);
            StringTokenizer st = new StringTokenizer(descriptorLocations, ", ");
            HashSet<String> haveBeenLoaded = new HashSet<String>();
            while (st.hasMoreTokens()) {
                String descriptorLocation = st.nextToken();
                URL[] descriptorURLs = BundleComponentActivator.findDescriptors(this.m_bundle, descriptorLocation);
                if (descriptorURLs.length == 0) {
                    this.logger.log(InternalLogger.Level.ERROR, "Component descriptor entry ''{0}'' not found", null, descriptorLocation);
                    continue;
                }
                for (URL descriptorURL : descriptorURLs) {
                    String externalForm = descriptorURL.toExternalForm();
                    if (!haveBeenLoaded.contains(externalForm)) {
                        this.loadDescriptor(descriptorURL);
                        haveBeenLoaded.add(externalForm);
                        continue;
                    }
                    this.logger.log(InternalLogger.Level.DEBUG, "Component descriptor entry ''{0}'' (matched by ''{1}'') has already been loaded", null, descriptorURL.getPath(), descriptorLocation);
                }
            }
        }
    }

    void initialEnable() {
        for (ComponentHolder<?> componentHolder : this.m_holders) {
            this.logger.log(InternalLogger.Level.DEBUG, "BundleComponentActivator : May enable component holder {0}", null, componentHolder.getComponentMetadata().getName());
            if (componentHolder.getComponentMetadata().isEnabled()) {
                this.logger.log(InternalLogger.Level.DEBUG, "BundleComponentActivator :Enabling component holder {0}", null, componentHolder.getComponentMetadata().getName());
                try {
                    componentHolder.enableComponents(false);
                }
                catch (Throwable t) {
                    try {
                        componentHolder.disableComponents(false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.logger.log(InternalLogger.Level.ERROR, "BundleComponentActivator : Unexpected failure enabling component holder {0}", t, componentHolder.getComponentMetadata().getName());
                }
                continue;
            }
            this.logger.log(InternalLogger.Level.DEBUG, "BundleComponentActivator : Will not enable component holder {0}", null, componentHolder.getComponentMetadata().getName());
        }
    }

    static URL[] findDescriptors(Bundle bundle, String descriptorLocation) {
        String filePattern;
        String path;
        if (bundle == null || descriptorLocation == null || descriptorLocation.trim().length() == 0) {
            return new URL[0];
        }
        int lios = descriptorLocation.lastIndexOf("/");
        if (lios > 0) {
            path = descriptorLocation.substring(0, lios);
            filePattern = descriptorLocation.substring(lios + 1);
        } else {
            path = "/";
            filePattern = descriptorLocation;
        }
        Enumeration entries = bundle.findEntries(path, filePattern, false);
        if (entries == null || !entries.hasMoreElements()) {
            return new URL[0];
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        while (entries.hasMoreElements()) {
            urls.add((URL)entries.nextElement());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDescriptor(URL descriptorURL) {
        String descriptorLocation = descriptorURL.getPath();
        InputStream stream = null;
        try {
            stream = descriptorURL.openStream();
            XmlHandler handler = new XmlHandler(this.m_bundle, this.logger, this.getConfiguration().isFactoryEnabled(), this.getConfiguration().keepInstances(), this.m_trueCondition);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            parser.parse(stream, (DefaultHandler)handler);
            for (ComponentMetadata metadata : handler.getComponentMetadataList()) {
                this.validateAndRegister(metadata);
            }
        }
        catch (IOException ex) {
            this.logger.log(InternalLogger.Level.ERROR, "Problem reading descriptor entry ''{0}''", ex, descriptorLocation);
        }
        catch (Exception ex) {
            this.logger.log(InternalLogger.Level.ERROR, "General problem with descriptor entry ''{0}''", ex, descriptorLocation);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    void validateAndRegister(ComponentMetadata metadata) {
        block2: {
            ComponentLogger componentLogger = this.logger.component(this.m_bundle, metadata.getImplementationClassName(), metadata.getName());
            ComponentRegistryKey key = null;
            try {
                metadata.validate();
                key = this.m_componentRegistry.checkComponentName(this.m_bundle, metadata.getName());
                ComponentHolder holder = this.m_componentRegistry.createComponentHolder(this, metadata, componentLogger);
                this.m_componentRegistry.registerComponentHolder(key, holder);
                this.m_holders.add(holder);
                componentLogger.log(InternalLogger.Level.DEBUG, "BundleComponentActivator : ComponentHolder created.", null);
            }
            catch (Throwable t) {
                componentLogger.log(InternalLogger.Level.ERROR, "Cannot register component", t);
                if (key == null) break block2;
                this.m_componentRegistry.unregisterComponentHolder(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose(int reason) {
        if (this.m_active.compareAndSet(true, false)) {
            this.logger.log(InternalLogger.Level.DEBUG, "BundleComponentActivator : Will destroy {0} instances", null, this.m_holders.size());
            for (ComponentHolder<?> holder : this.m_holders) {
                try {
                    holder.disposeComponents(reason);
                }
                catch (Exception e) {
                    this.logger.log(InternalLogger.Level.ERROR, "BundleComponentActivator : Exception invalidating", e, holder.getComponentMetadata());
                }
                finally {
                    this.m_componentRegistry.unregisterComponentHolder(this.m_bundle, holder.getComponentMetadata().getName());
                }
            }
            if (this.configAdminTracker != null) {
                this.configAdminTracker.dispose();
            }
            this.logger.log(InternalLogger.Level.DEBUG, "BundleComponentActivator : Bundle STOPPED", null);
            this.m_closeLatch.countDown();
        } else {
            try {
                this.m_closeLatch.await(this.m_configuration.lockTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.m_active.get();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.m_context;
    }

    @Override
    public ScrConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public void enableComponent(String name) {
        List<ComponentHolder<?>> holder = this.getSelectedComponents(name);
        for (ComponentHolder<?> aHolder : holder) {
            try {
                this.logger.log(InternalLogger.Level.DEBUG, "Enabling Component {0}", null, aHolder.getComponentMetadata().getName());
                aHolder.enableComponents(true);
            }
            catch (Throwable t) {
                this.logger.log(InternalLogger.Level.ERROR, "Cannot enable component {0}", t, aHolder.getComponentMetadata().getName());
            }
        }
    }

    @Override
    public void disableComponent(String name) {
        List<ComponentHolder<?>> holder = this.getSelectedComponents(name);
        for (ComponentHolder<?> aHolder : holder) {
            try {
                this.logger.log(InternalLogger.Level.DEBUG, "Disabling Component {0}", null, aHolder.getComponentMetadata().getName());
                aHolder.disableComponents(true);
            }
            catch (Throwable t) {
                this.logger.log(InternalLogger.Level.ERROR, "Cannot disable component {0}", t, aHolder.getComponentMetadata().getName());
            }
        }
    }

    List<ComponentHolder<?>> getSelectedComponents(String name) {
        if (name == null) {
            return this.m_holders;
        }
        ComponentHolder<?> componentHolder = this.m_componentRegistry.getComponentHolder(this.m_bundle, name);
        if (componentHolder != null) {
            return Collections.singletonList(componentHolder);
        }
        return Collections.emptyList();
    }

    @Override
    public long registerComponentId(AbstractComponentManager<?> componentManager) {
        return this.m_componentRegistry.registerComponentId(componentManager);
    }

    @Override
    public void unregisterComponentId(AbstractComponentManager<?> componentManager) {
        this.m_componentRegistry.unregisterComponentId(componentManager.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(Runnable task) {
        if (this.isActive()) {
            ComponentActorThread cat = this.m_componentActor;
            if (cat != null) {
                cat.schedule(task);
            } else {
                this.logger.log(InternalLogger.Level.DEBUG, "Component Actor Thread not running, calling synchronously", null);
                try {
                    BundleComponentActivator bundleComponentActivator = this;
                    synchronized (bundleComponentActivator) {
                        task.run();
                    }
                }
                catch (Throwable t) {
                    this.logger.log(InternalLogger.Level.WARN, "Unexpected problem executing task", t);
                }
            }
        } else {
            this.logger.log(InternalLogger.Level.WARN, "BundleComponentActivator is not active; not scheduling {0}", null, task);
        }
    }

    @Override
    public BundleLogger getLogger() {
        return this.logger;
    }

    @Override
    public <T> boolean enterCreate(ServiceReference<T> serviceReference) {
        return this.m_componentRegistry.enterCreate(serviceReference);
    }

    @Override
    public <T> void leaveCreate(ServiceReference<T> serviceReference) {
        this.m_componentRegistry.leaveCreate(serviceReference);
    }

    @Override
    public <T> void missingServicePresent(ServiceReference<T> serviceReference) {
        this.m_componentRegistry.missingServicePresent(serviceReference, this.m_componentActor);
    }

    @Override
    public <S, T> void registerMissingDependency(DependencyManager<S, T> dependencyManager, ServiceReference<T> serviceReference, int trackingCount) {
        this.m_componentRegistry.registerMissingDependency(dependencyManager, serviceReference, trackingCount);
    }

    @Override
    public RegionConfigurationSupport setRegionConfigurationSupport(ServiceReference<ConfigurationAdmin> reference) {
        RegionConfigurationSupport rcs = this.m_componentRegistry.registerRegionConfigurationSupport(reference);
        if (rcs != null) {
            for (ComponentHolder<?> holder : this.m_holders) {
                rcs.configureComponentHolder(holder);
            }
        }
        return rcs;
    }

    @Override
    public void unsetRegionConfigurationSupport(RegionConfigurationSupport rcs) {
        this.m_componentRegistry.unregisterRegionConfigurationSupport(rcs);
    }

    @Override
    public void updateChangeCount() {
        this.m_componentRegistry.updateChangeCount();
    }

    @Override
    public ServiceReference<?> getTrueCondition() {
        return this.m_trueCondition;
    }

    private static class ListenerInfo
    implements ServiceListener {
        List<ExtendedServiceListener<ExtendedServiceEvent>> listeners = new ArrayList<ExtendedServiceListener<ExtendedServiceEvent>>();

        private ListenerInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent event) {
            List<ExtendedServiceListener<ExtendedServiceEvent>> listeners;
            ExtendedServiceEvent extEvent = new ExtendedServiceEvent(event);
            ListenerInfo listenerInfo = this;
            synchronized (listenerInfo) {
                listeners = this.listeners;
            }
            for (ExtendedServiceListener extendedServiceListener : listeners) {
                extendedServiceListener.serviceChanged(extEvent);
            }
            if (extEvent != null) {
                extEvent.activateManagers();
            }
        }

        public synchronized void add(ExtendedServiceListener<ExtendedServiceEvent> listener) {
            this.listeners = new ArrayList<ExtendedServiceListener<ExtendedServiceEvent>>(this.listeners);
            this.listeners.add(listener);
        }

        public synchronized boolean remove(ExtendedServiceListener<ExtendedServiceEvent> listener) {
            this.listeners = new ArrayList<ExtendedServiceListener<ExtendedServiceEvent>>(this.listeners);
            this.listeners.remove(listener);
            return this.listeners.isEmpty();
        }
    }
}

