/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.addons.camera;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rap.fileupload.FileDetails;
import org.eclipse.rap.fileupload.FileUploadEvent;
import org.eclipse.rap.fileupload.FileUploadHandler;
import org.eclipse.rap.fileupload.FileUploadListener;
import org.eclipse.rap.fileupload.FileUploadReceiver;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.addons.camera.CameraListener;
import org.eclipse.rap.rwt.addons.camera.CameraOptions;
import org.eclipse.rap.rwt.client.service.ClientFileLoader;
import org.eclipse.rap.rwt.remote.Connection;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.rap.rwt.service.UISessionEvent;
import org.eclipse.rap.rwt.service.UISessionListener;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class Camera
extends Composite {
    private static final Pattern SERVICE_URL_PATTERN = Pattern.compile(".*/([^/.]*\\?.*)");
    public static final String PROPERTY_PARENT = "parent";
    public static final String PROPERTY_UPLOAD_PATH = "uploadPath";
    public static final String PROPERTY_RESOLUTION = "resolution";
    public static final String PROPERTY_COMPRESSON_QUALITY = "compressionQuality";
    public static final String METHOD_TAKE_PICTURE = "takePicture";
    private static final String RESOURCES_PATH = "org/eclipse/rap/rwt/addons/camera/";
    private static final String REGISTER_PATH = "camera/";
    private static final String[] RESOURCES_FILES = new String[]{"Camera.js", "camera-flip-32.png"};
    private static final String REMOTE_TYPE = "rwt.widgets.Camera";
    private final RemoteObject remoteObject;
    private final List<CameraListener> cameraListeners;
    private final ServerPushSession serverPush;

    public Camera(Composite parent) {
        this(parent, 0);
    }

    public Camera(Composite parent, int style) {
        super(parent, style);
        Camera.registerResources();
        Camera.loadJavaScript();
        Connection connection = RWT.getUISession().getConnection();
        this.remoteObject = connection.createRemoteObject(REMOTE_TYPE);
        this.remoteObject.set(PROPERTY_PARENT, WidgetUtil.getId((Widget)this));
        this.cameraListeners = new ArrayList<CameraListener>();
        this.serverPush = new ServerPushSession();
        String uploadPath = this.registerFileUploadServiceHandler();
        this.remoteObject.set(PROPERTY_UPLOAD_PATH, Camera.stripContextPath(uploadPath));
    }

    public void takePicture(CameraOptions options) {
        this.checkWidget();
        if (options == null) {
            SWT.error((int)4);
        }
        this.remoteObject.call(METHOD_TAKE_PICTURE, Camera.createProperties(options));
        this.serverPush.start();
    }

    public void addCameraListener(CameraListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.cameraListeners.add(listener);
    }

    public void removeCameraListener(CameraListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.cameraListeners.remove(listener);
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.remoteObject.destroy();
        }
        super.dispose();
    }

    RemoteObject getRemoteObject() {
        return this.remoteObject;
    }

    private static void registerResources() {
        ResourceManager resourceManager = RWT.getResourceManager();
        String[] stringArray = RESOURCES_FILES;
        int n = RESOURCES_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            Camera.registerFileIfNeeded(resourceManager, fileName);
            ++n2;
        }
    }

    private static void registerFileIfNeeded(ResourceManager resourceManager, String fileName) {
        boolean isRegistered = resourceManager.isRegistered(REGISTER_PATH + fileName);
        if (!isRegistered) {
            try {
                Camera.register(resourceManager, fileName);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Failed to load resources", ioe);
            }
        }
    }

    private static void loadJavaScript() {
        ClientFileLoader loader = (ClientFileLoader)RWT.getClient().getService(ClientFileLoader.class);
        ResourceManager resourceManager = RWT.getResourceManager();
        loader.requireJs(resourceManager.getLocation("camera/Camera.js"));
    }

    private static void register(ResourceManager resourceManager, String fileName) throws IOException {
        ClassLoader classLoader = Camera.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(RESOURCES_PATH + fileName);){
            resourceManager.register(REGISTER_PATH + fileName, inputStream);
        }
    }

    private static JsonObject createProperties(CameraOptions options) {
        JsonObject properties = new JsonObject();
        Camera.addResolution(properties, options);
        Camera.addCompressionQuality(properties, options);
        return properties;
    }

    private static void addResolution(JsonObject properties, CameraOptions options) {
        Point resolution = options.getResolution();
        if (resolution != null) {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(resolution.x);
            jsonArray.add(resolution.y);
            properties.add(PROPERTY_RESOLUTION, (JsonValue)jsonArray);
        }
    }

    private static void addCompressionQuality(JsonObject properties, CameraOptions options) {
        properties.add(PROPERTY_COMPRESSON_QUALITY, options.getCompressionQuality());
    }

    void handleUploadFailed(Display display, final ImageUploadReceiver receiver) {
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Camera.this.notifyListenersWithoutPicture();
                    receiver.reset();
                    Camera.this.serverPush.stop();
                }
            });
        }
    }

    void handleUploadFinished(Display display, final ImageUploadReceiver receiver) {
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Camera.this.notifyListenersWithImage(receiver.getImage());
                    receiver.reset();
                    Camera.this.serverPush.stop();
                }
            });
        }
    }

    private void notifyListenersWithImage(Image image) {
        ArrayList<CameraListener> listeners = new ArrayList<CameraListener>(this.cameraListeners);
        for (CameraListener listener : listeners) {
            listener.receivedPicture(image);
        }
    }

    private void notifyListenersWithoutPicture() {
        ArrayList<CameraListener> listeners = new ArrayList<CameraListener>(this.cameraListeners);
        for (CameraListener listener : listeners) {
            listener.receivedPicture(null);
        }
    }

    private String registerFileUploadServiceHandler() {
        final Display display = this.getDisplay();
        final ImageUploadReceiver receiver = new ImageUploadReceiver(display);
        final FileUploadHandler uploadHandler = new FileUploadHandler((FileUploadReceiver)receiver);
        uploadHandler.addUploadListener(new FileUploadListener(){

            public void uploadProgress(FileUploadEvent event) {
            }

            public void uploadFailed(FileUploadEvent event) {
                Camera.this.handleUploadFailed(display, receiver);
            }

            public void uploadFinished(FileUploadEvent event) {
                Camera.this.handleUploadFinished(display, receiver);
            }
        });
        RWT.getUISession().addUISessionListener(new UISessionListener(){

            public void beforeDestroy(UISessionEvent event) {
                uploadHandler.dispose();
            }
        });
        return uploadHandler.getUploadUrl();
    }

    static String stripContextPath(String serviceHandlerUrl) {
        Matcher matcher = SERVICE_URL_PATTERN.matcher(serviceHandlerUrl);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return serviceHandlerUrl;
    }

    public class ImageUploadReceiver
    extends FileUploadReceiver {
        private final Display display;
        private Image image;

        public ImageUploadReceiver(Display display) {
            this.display = display;
        }

        public void receive(InputStream stream, FileDetails details) throws IOException {
            this.image = new Image((Device)this.display, stream);
        }

        public Image getImage() {
            return this.image;
        }

        public void reset() {
            this.image = null;
        }
    }
}

