/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.serverpush.ServerPushManager;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.service.UISession;

public class ServerPushRenderer {
    public static final String REMOTE_OBJECT_ID = "rwt.client.ServerPush";
    private static final String PROP_ACTIVE = "active";
    private static final String ATTR_PRESERVED_ACTIVATION = ServerPushRenderer.class.getName() + ".preservedActivation";
    private final UISession uiSession = ContextProvider.getUISession();
    private final ServerPushManager pushManager = ServerPushManager.getInstance();

    ServerPushRenderer() {
    }

    void render() {
        boolean activation = this.pushManager.needsActivation();
        if (this.mustRender(activation)) {
            this.renderActivation(activation);
            this.preserveActivation(activation);
        }
    }

    private boolean mustRender(boolean activation) {
        boolean result = this.hasChanged(activation);
        if (result && !activation && this.pushManager.hasRunnables()) {
            result = false;
        }
        return result;
    }

    private boolean hasChanged(boolean activation) {
        return activation ^ this.getPreservedActivation();
    }

    private void preserveActivation(boolean activation) {
        this.uiSession.setAttribute(ATTR_PRESERVED_ACTIVATION, activation);
    }

    private boolean getPreservedActivation() {
        Boolean preserved = (Boolean)this.uiSession.getAttribute(ATTR_PRESERVED_ACTIVATION);
        return preserved != null ? preserved : false;
    }

    void renderActivation(boolean activation) {
        ProtocolMessageWriter writer = ContextProvider.getProtocolWriter();
        writer.appendSet(REMOTE_OBJECT_ID, PROP_ACTIVE, activation);
    }
}

