/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.NumberFormat;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.theme.BoxDimensions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.spinnerkit.SpinnerLCA;
import org.eclipse.swt.internal.widgets.spinnerkit.SpinnerThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    public static final int LIMIT = Integer.MAX_VALUE;
    private static final int UP_DOWN_MIN_HEIGHT = 18;
    private int minimum = 0;
    private int maximum = 100;
    private int digits = 0;
    private int increment = 1;
    private int pageIncrement = 10;
    private int selection = 0;
    private int textLimit = Integer.MAX_VALUE;

    public Spinner(Composite parent, int style) {
        super(parent, Spinner.checkStyle(style));
    }

    @Override
    void initState() {
        this.removeState(256);
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    public void setDigits(int value) {
        this.checkWidget();
        if (value < 0) {
            this.error(5);
        }
        this.digits = value;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value >= 1) {
            this.increment = value;
        }
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value <= this.maximum) {
            this.minimum = value;
            if (this.selection < this.minimum) {
                this.selection = this.minimum;
            }
        }
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value >= this.minimum) {
            this.maximum = value;
            if (this.selection > this.maximum) {
                this.selection = this.maximum;
            }
        }
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value >= 1) {
            this.pageIncrement = value;
        }
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setSelection(int value) {
        this.checkWidget();
        this.selection = Math.min(Math.max(this.minimum, value), this.maximum);
        this.notifyListeners(24, new Event());
    }

    public void setValues(int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        this.checkWidget();
        if (maximum >= minimum && digits >= 0 && increment >= 1 && pageIncrement >= 1) {
            this.minimum = minimum;
            this.maximum = maximum;
            this.digits = digits;
            this.increment = increment;
            this.pageIncrement = pageIncrement;
            this.setSelection(selection);
        }
    }

    public String getText() {
        this.checkWidget();
        String result = String.valueOf(this.selection);
        if (this.digits > 0) {
            NumberFormat nf = NumberFormat.getInstance(RWT.getLocale());
            nf.setMinimumFractionDigits(this.digits);
            nf.setMaximumFractionDigits(this.digits);
            result = nf.format((double)this.selection / Math.pow(10.0, this.digits));
        }
        return result;
    }

    public void setTextLimit(int textLimit) {
        this.checkWidget();
        if (textLimit == 0) {
            this.error(7);
        }
        this.textLimit = textLimit;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            int maxValue = Math.max(Math.abs(this.maximum), Math.abs(this.minimum));
            Object string = String.valueOf(maxValue);
            if (this.digits > 0) {
                StringBuilder buffer = new StringBuilder();
                buffer.append((String)string);
                buffer.append(",");
                int count = this.digits - ((String)string).length();
                while (count >= 0) {
                    buffer.append("0");
                    --count;
                }
                string = buffer.toString();
            }
            if (this.minimum < 0 || this.maximum < 0) {
                string = (String)string + "-";
            }
            Point textSize = TextSizeUtil.stringExtent(this.getFont(), (String)string);
            BoxDimensions padding = this.getFieldPadding();
            int buttonWidth = this.getButtonWidth();
            width = textSize.x + buttonWidth + padding.left + padding.right;
            height = textSize.y + padding.top + padding.bottom;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        if (hHint == -1) {
            BoxDimensions border = this.getBorder();
            int upDownHeight = 18 + border.top + border.bottom;
            trim.height = Math.max(trim.height, upDownHeight);
        }
        return new Point(trim.width, trim.height);
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle result = new Rectangle(x, y, width, height);
        if ((this.style & 0x800) != 0) {
            BoxDimensions border = this.getBorder();
            result.x -= border.left;
            result.y -= border.top;
            result.width += border.left + border.right;
            result.height += border.top + border.bottom;
        }
        int buttonWidth = this.getButtonWidth();
        result.width += buttonWidth;
        return result;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(24, listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == WidgetLCA.class) {
            return (T)SpinnerLCA.INSTANCE;
        }
        return super.getAdapter(adapter);
    }

    private BoxDimensions getFieldPadding() {
        return this.getThemeAdapter().getFieldPadding(this);
    }

    private int getButtonWidth() {
        return this.getThemeAdapter().getButtonWidth(this);
    }

    private SpinnerThemeAdapter getThemeAdapter() {
        return (SpinnerThemeAdapter)this.getAdapter(ThemeAdapter.class);
    }

    private static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }
}

